/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.common.redis;

import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.stereotype.Component;

@Component
public class RedisTemplateHelper {
    @Autowired
    private StringRedisTemplate redisTemplate;

    private void scan(String string, Consumer<byte[]> consumer) {
        this.redisTemplate.execute(redisConnection -> {
            Object var4_5;
            block8: {
                Cursor cursor = redisConnection.scan(ScanOptions.scanOptions().count(Long.MAX_VALUE).match(string).build());
                try {
                    cursor.forEachRemaining(consumer);
                    var4_5 = null;
                    if (cursor == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (cursor != null) {
                            try {
                                cursor.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (DataAccessException dataAccessException) {
                        throw new RuntimeException(dataAccessException);
                    }
                }
                cursor.close();
            }
            return var4_5;
        });
    }

    public Set<String> scan(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        this.scan(string, byArray -> {
            String string = new String((byte[])byArray, StandardCharsets.UTF_8);
            hashSet.add(string);
        });
        return hashSet;
    }

    public void deleteByPattern(String string) {
        Set<String> set = this.scan(string);
        this.redisTemplate.delete(set);
    }

    public void delete(String string) {
        this.redisTemplate.delete((Object)string);
    }

    public void delete(Collection<String> collection) {
        this.redisTemplate.delete(collection);
    }

    public byte[] dump(String string) {
        return this.redisTemplate.dump((Object)string);
    }

    public Boolean hasKey(String string) {
        return this.redisTemplate.hasKey((Object)string);
    }

    public Boolean expire(String string, long l, TimeUnit timeUnit) {
        return this.redisTemplate.expire((Object)string, l, timeUnit);
    }

    public Boolean expireAt(String string, Date date) {
        return this.redisTemplate.expireAt((Object)string, date);
    }

    public Set<String> keys(String string) {
        return this.redisTemplate.keys((Object)string);
    }

    public Boolean move(String string, int n) {
        return this.redisTemplate.move((Object)string, n);
    }

    public Boolean persist(String string) {
        return this.redisTemplate.persist((Object)string);
    }

    public Long getExpire(String string, TimeUnit timeUnit) {
        return this.redisTemplate.getExpire((Object)string, timeUnit);
    }

    public Long getExpire(String string) {
        return this.redisTemplate.getExpire((Object)string);
    }

    public String randomKey() {
        return (String)this.redisTemplate.randomKey();
    }

    public void rename(String string, String string2) {
        this.redisTemplate.rename((Object)string, (Object)string2);
    }

    public Boolean renameIfAbsent(String string, String string2) {
        return this.redisTemplate.renameIfAbsent((Object)string, (Object)string2);
    }

    public DataType type(String string) {
        return this.redisTemplate.type((Object)string);
    }

    public void set(String string, String string2) {
        this.redisTemplate.opsForValue().set((Object)string, (Object)string2);
    }

    public void set(String string, String string2, long l, TimeUnit timeUnit) {
        this.redisTemplate.opsForValue().set((Object)string, (Object)string2, l, timeUnit);
    }

    public String get(String string) {
        return (String)this.redisTemplate.opsForValue().get((Object)string);
    }

    public String getRange(String string, long l, long l2) {
        return this.redisTemplate.opsForValue().get((Object)string, l, l2);
    }

    public String getAndSet(String string, String string2) {
        return (String)this.redisTemplate.opsForValue().getAndSet((Object)string, (Object)string2);
    }

    public Boolean getBit(String string, long l) {
        return this.redisTemplate.opsForValue().getBit((Object)string, l);
    }

    public List<String> multiGet(Collection<String> collection) {
        return this.redisTemplate.opsForValue().multiGet(collection);
    }

    public boolean setBit(String string, long l, boolean bl) {
        return this.redisTemplate.opsForValue().setBit((Object)string, l, bl);
    }

    public boolean setIfAbsent(String string, String string2) {
        return this.redisTemplate.opsForValue().setIfAbsent((Object)string, (Object)string2);
    }

    public void setRange(String string, String string2, long l) {
        this.redisTemplate.opsForValue().set((Object)string, (Object)string2, l);
    }

    public Long size(String string) {
        return this.redisTemplate.opsForValue().size((Object)string);
    }

    public void multiSet(Map<String, String> map) {
        this.redisTemplate.opsForValue().multiSet(map);
    }

    public boolean multiSetIfAbsent(Map<String, String> map) {
        return this.redisTemplate.opsForValue().multiSetIfAbsent(map);
    }

    public Long incrBy(String string, long l) {
        return this.redisTemplate.opsForValue().increment((Object)string, l);
    }

    public Double incrByFloat(String string, double d) {
        return this.redisTemplate.opsForValue().increment((Object)string, d);
    }

    public Integer append(String string, String string2) {
        return this.redisTemplate.opsForValue().append((Object)string, string2);
    }

    public Object hGet(String string, String string2) {
        return this.redisTemplate.opsForHash().get((Object)string, (Object)string2);
    }

    public Map<Object, Object> hGetAll(String string) {
        return this.redisTemplate.opsForHash().entries((Object)string);
    }

    public List<Object> hMultiGet(String string, Collection<Object> collection) {
        return this.redisTemplate.opsForHash().multiGet((Object)string, collection);
    }

    public void hPut(String string, String string2, String string3) {
        this.redisTemplate.opsForHash().put((Object)string, (Object)string2, (Object)string3);
    }

    public void hPutAll(String string, Map<String, String> map) {
        this.redisTemplate.opsForHash().putAll((Object)string, map);
    }

    public Boolean hPutIfAbsent(String string, String string2, String string3) {
        return this.redisTemplate.opsForHash().putIfAbsent((Object)string, (Object)string2, (Object)string3);
    }

    public Long hDelete(String string, Object ... objectArray) {
        return this.redisTemplate.opsForHash().delete((Object)string, objectArray);
    }

    public boolean hExists(String string, String string2) {
        return this.redisTemplate.opsForHash().hasKey((Object)string, (Object)string2);
    }

    public Long hIncrBy(String string, Object object, long l) {
        return this.redisTemplate.opsForHash().increment((Object)string, object, l);
    }

    public Double hIncrByFloat(String string, Object object, double d) {
        return this.redisTemplate.opsForHash().increment((Object)string, object, d);
    }

    public Set<Object> hKeys(String string) {
        return this.redisTemplate.opsForHash().keys((Object)string);
    }

    public Long hSize(String string) {
        return this.redisTemplate.opsForHash().size((Object)string);
    }

    public List<Object> hValues(String string) {
        return this.redisTemplate.opsForHash().values((Object)string);
    }

    public Cursor<Map.Entry<Object, Object>> hScan(String string, ScanOptions scanOptions) {
        return this.redisTemplate.opsForHash().scan((Object)string, scanOptions);
    }

    public String lIndex(String string, long l) {
        return (String)this.redisTemplate.opsForList().index((Object)string, l);
    }

    public List<String> lRange(String string, long l, long l2) {
        return this.redisTemplate.opsForList().range((Object)string, l, l2);
    }

    public Long lLeftPush(String string, String string2) {
        return this.redisTemplate.opsForList().leftPush((Object)string, (Object)string2);
    }

    public Long lLeftPushAll(String string, String ... stringArray) {
        return this.redisTemplate.opsForList().leftPushAll((Object)string, (Object[])stringArray);
    }

    public Long lLeftPushAll(String string, Collection<String> collection) {
        return this.redisTemplate.opsForList().leftPushAll((Object)string, collection);
    }

    public Long lLeftPushIfPresent(String string, String string2) {
        return this.redisTemplate.opsForList().leftPushIfPresent((Object)string, (Object)string2);
    }

    public Long lLeftPush(String string, String string2, String string3) {
        return this.redisTemplate.opsForList().leftPush((Object)string, (Object)string2, (Object)string3);
    }

    public Long lRightPush(String string, String string2) {
        return this.redisTemplate.opsForList().rightPush((Object)string, (Object)string2);
    }

    public Long lRightPushAll(String string, String ... stringArray) {
        return this.redisTemplate.opsForList().rightPushAll((Object)string, (Object[])stringArray);
    }

    public Long lRightPushAll(String string, Collection<String> collection) {
        return this.redisTemplate.opsForList().rightPushAll((Object)string, collection);
    }

    public Long lRightPushIfPresent(String string, String string2) {
        return this.redisTemplate.opsForList().rightPushIfPresent((Object)string, (Object)string2);
    }

    public Long lRightPush(String string, String string2, String string3) {
        return this.redisTemplate.opsForList().rightPush((Object)string, (Object)string2, (Object)string3);
    }

    public void lSet(String string, long l, String string2) {
        this.redisTemplate.opsForList().set((Object)string, l, (Object)string2);
    }

    public String lLeftPop(String string) {
        return (String)this.redisTemplate.opsForList().leftPop((Object)string);
    }

    public String lBLeftPop(String string, long l, TimeUnit timeUnit) {
        return (String)this.redisTemplate.opsForList().leftPop((Object)string, l, timeUnit);
    }

    public String lRightPop(String string) {
        return (String)this.redisTemplate.opsForList().rightPop((Object)string);
    }

    public String lBRightPop(String string, long l, TimeUnit timeUnit) {
        return (String)this.redisTemplate.opsForList().rightPop((Object)string, l, timeUnit);
    }

    public String lRightPopAndLeftPush(String string, String string2) {
        return (String)this.redisTemplate.opsForList().rightPopAndLeftPush((Object)string, (Object)string2);
    }

    public String lBRightPopAndLeftPush(String string, String string2, long l, TimeUnit timeUnit) {
        return (String)this.redisTemplate.opsForList().rightPopAndLeftPush((Object)string, (Object)string2, l, timeUnit);
    }

    public Long lRemove(String string, long l, String string2) {
        return this.redisTemplate.opsForList().remove((Object)string, l, (Object)string2);
    }

    public void lTrim(String string, long l, long l2) {
        this.redisTemplate.opsForList().trim((Object)string, l, l2);
    }

    public Long lLen(String string) {
        return this.redisTemplate.opsForList().size((Object)string);
    }

    public Long sAdd(String string, String ... stringArray) {
        return this.redisTemplate.opsForSet().add((Object)string, (Object[])stringArray);
    }

    public Long sRemove(String string, Object ... objectArray) {
        return this.redisTemplate.opsForSet().remove((Object)string, objectArray);
    }

    public String sPop(String string) {
        return (String)this.redisTemplate.opsForSet().pop((Object)string);
    }

    public Boolean sMove(String string, String string2, String string3) {
        return this.redisTemplate.opsForSet().move((Object)string, (Object)string2, (Object)string3);
    }

    public Long sSize(String string) {
        return this.redisTemplate.opsForSet().size((Object)string);
    }

    public Boolean sIsMember(String string, Object object) {
        return this.redisTemplate.opsForSet().isMember((Object)string, object);
    }

    public Set<String> sIntersect(String string, String string2) {
        return this.redisTemplate.opsForSet().intersect((Object)string, (Object)string2);
    }

    public Set<String> sIntersect(String string, Collection<String> collection) {
        return this.redisTemplate.opsForSet().intersect((Object)string, collection);
    }

    public Long sIntersectAndStore(String string, String string2, String string3) {
        return this.redisTemplate.opsForSet().intersectAndStore((Object)string, (Object)string2, (Object)string3);
    }

    public Long sIntersectAndStore(String string, Collection<String> collection, String string2) {
        return this.redisTemplate.opsForSet().intersectAndStore((Object)string, collection, (Object)string2);
    }

    public Set<String> sUnion(String string, String string2) {
        return this.redisTemplate.opsForSet().union((Object)string, (Object)string2);
    }

    public Set<String> sUnion(String string, Collection<String> collection) {
        return this.redisTemplate.opsForSet().union((Object)string, collection);
    }

    public Long sUnionAndStore(String string, String string2, String string3) {
        return this.redisTemplate.opsForSet().unionAndStore((Object)string, (Object)string2, (Object)string3);
    }

    public Long sUnionAndStore(String string, Collection<String> collection, String string2) {
        return this.redisTemplate.opsForSet().unionAndStore((Object)string, collection, (Object)string2);
    }

    public Set<String> sDifference(String string, String string2) {
        return this.redisTemplate.opsForSet().difference((Object)string, (Object)string2);
    }

    public Set<String> sDifference(String string, Collection<String> collection) {
        return this.redisTemplate.opsForSet().difference((Object)string, collection);
    }

    public Long sDifference(String string, String string2, String string3) {
        return this.redisTemplate.opsForSet().differenceAndStore((Object)string, (Object)string2, (Object)string3);
    }

    public Long sDifference(String string, Collection<String> collection, String string2) {
        return this.redisTemplate.opsForSet().differenceAndStore((Object)string, collection, (Object)string2);
    }

    public Set<String> setMembers(String string) {
        return this.redisTemplate.opsForSet().members((Object)string);
    }

    public String sRandomMember(String string) {
        return (String)this.redisTemplate.opsForSet().randomMember((Object)string);
    }

    public List<String> sRandomMembers(String string, long l) {
        return this.redisTemplate.opsForSet().randomMembers((Object)string, l);
    }

    public Set<String> sDistinctRandomMembers(String string, long l) {
        return this.redisTemplate.opsForSet().distinctRandomMembers((Object)string, l);
    }

    public Cursor<String> sScan(String string, ScanOptions scanOptions) {
        return this.redisTemplate.opsForSet().scan((Object)string, scanOptions);
    }

    public Boolean zAdd(String string, String string2, double d) {
        return this.redisTemplate.opsForZSet().add((Object)string, (Object)string2, d);
    }

    public Long zAdd(String string, Set<ZSetOperations.TypedTuple<String>> set) {
        return this.redisTemplate.opsForZSet().add((Object)string, set);
    }

    public Long zRemove(String string, Object ... objectArray) {
        return this.redisTemplate.opsForZSet().remove((Object)string, objectArray);
    }

    public Double zIncrementScore(String string, String string2, double d) {
        return this.redisTemplate.opsForZSet().incrementScore((Object)string, (Object)string2, d);
    }

    public Long zRank(String string, Object object) {
        return this.redisTemplate.opsForZSet().rank((Object)string, object);
    }

    public Long zReverseRank(String string, Object object) {
        return this.redisTemplate.opsForZSet().reverseRank((Object)string, object);
    }

    public Set<String> zRange(String string, long l, long l2) {
        return this.redisTemplate.opsForZSet().range((Object)string, l, l2);
    }

    public Set<ZSetOperations.TypedTuple<String>> zRangeWithScores(String string, long l, long l2) {
        return this.redisTemplate.opsForZSet().rangeWithScores((Object)string, l, l2);
    }

    public Set<String> zRangeByScore(String string, double d, double d2) {
        return this.redisTemplate.opsForZSet().rangeByScore((Object)string, d, d2);
    }

    public Set<ZSetOperations.TypedTuple<String>> zRangeByScoreWithScores(String string, double d, double d2) {
        return this.redisTemplate.opsForZSet().rangeByScoreWithScores((Object)string, d, d2);
    }

    public Set<ZSetOperations.TypedTuple<String>> zRangeByScoreWithScores(String string, double d, double d2, long l, long l2) {
        return this.redisTemplate.opsForZSet().rangeByScoreWithScores((Object)string, d, d2, l, l2);
    }

    public Set<String> zReverseRange(String string, long l, long l2) {
        return this.redisTemplate.opsForZSet().reverseRange((Object)string, l, l2);
    }

    public Set<ZSetOperations.TypedTuple<String>> zReverseRangeWithScores(String string, long l, long l2) {
        return this.redisTemplate.opsForZSet().reverseRangeWithScores((Object)string, l, l2);
    }

    public Set<String> zReverseRangeByScore(String string, double d, double d2) {
        return this.redisTemplate.opsForZSet().reverseRangeByScore((Object)string, d, d2);
    }

    public Set<ZSetOperations.TypedTuple<String>> zReverseRangeByScoreWithScores(String string, double d, double d2) {
        return this.redisTemplate.opsForZSet().reverseRangeByScoreWithScores((Object)string, d, d2);
    }

    public Set<String> zReverseRangeByScore(String string, double d, double d2, long l, long l2) {
        return this.redisTemplate.opsForZSet().reverseRangeByScore((Object)string, d, d2, l, l2);
    }

    public Long zCount(String string, double d, double d2) {
        return this.redisTemplate.opsForZSet().count((Object)string, d, d2);
    }

    public Long zSize(String string) {
        return this.redisTemplate.opsForZSet().size((Object)string);
    }

    public Long zZCard(String string) {
        return this.redisTemplate.opsForZSet().zCard((Object)string);
    }

    public Double zScore(String string, Object object) {
        return this.redisTemplate.opsForZSet().score((Object)string, object);
    }

    public Long zRemoveRange(String string, long l, long l2) {
        return this.redisTemplate.opsForZSet().removeRange((Object)string, l, l2);
    }

    public Long zRemoveRangeByScore(String string, double d, double d2) {
        return this.redisTemplate.opsForZSet().removeRangeByScore((Object)string, d, d2);
    }

    public Long zUnionAndStore(String string, String string2, String string3) {
        return this.redisTemplate.opsForZSet().unionAndStore((Object)string, (Object)string2, (Object)string3);
    }

    public Long zUnionAndStore(String string, Collection<String> collection, String string2) {
        return this.redisTemplate.opsForZSet().unionAndStore((Object)string, collection, (Object)string2);
    }

    public Long zIntersectAndStore(String string, String string2, String string3) {
        return this.redisTemplate.opsForZSet().intersectAndStore((Object)string, (Object)string2, (Object)string3);
    }

    public Long zIntersectAndStore(String string, Collection<String> collection, String string2) {
        return this.redisTemplate.opsForZSet().intersectAndStore((Object)string, collection, (Object)string2);
    }

    public Cursor<ZSetOperations.TypedTuple<String>> zScan(String string, ScanOptions scanOptions) {
        return this.redisTemplate.opsForZSet().scan((Object)string, scanOptions);
    }

    public RedisConnectionFactory getConnectionFactory() {
        return this.redisTemplate.getConnectionFactory();
    }
}

