/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.common.serviceimpl;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import plus.hiver.common.base.HiverBaseDao;
import plus.hiver.common.dao.DepartmentHeaderDao;
import plus.hiver.common.dao.UserDao;
import plus.hiver.common.entity.DepartmentHeader;
import plus.hiver.common.entity.User;
import plus.hiver.common.service.DepartmentHeaderService;
import plus.hiver.common.vo.UserVo;

@Service
@Transactional
public class DepartmentHeaderServiceImpl
implements DepartmentHeaderService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DepartmentHeaderServiceImpl.class);
    @Autowired
    private DepartmentHeaderDao departmentHeaderDao;
    @Autowired
    private UserDao userDao;

    @Override
    public HiverBaseDao<DepartmentHeader, Long> getRepository() {
        return this.departmentHeaderDao;
    }

    @Override
    public List<UserVo> findHeaderByDepartmentId(Long l, Integer n) {
        ArrayList<UserVo> arrayList = new ArrayList<UserVo>();
        List<DepartmentHeader> list = this.departmentHeaderDao.findByDepartmentIdAndType(l, n);
        list.forEach(departmentHeader -> {
            User user = (User)this.userDao.getOne(departmentHeader.getUserId());
            if (user != null) {
                arrayList.add(new UserVo().setId(user.getId()).setUsername(user.getUsername()).setNickname(user.getNickname()));
            }
        });
        return arrayList;
    }

    @Override
    public List<DepartmentHeader> findByDepartmentIdIn(List<Long> list) {
        return this.departmentHeaderDao.findByDepartmentIdIn(list);
    }

    @Override
    public void deleteByDepartmentId(Long l) {
        this.departmentHeaderDao.deleteByDepartmentId(l);
    }

    @Override
    public void deleteByUserId(Long l) {
        this.departmentHeaderDao.deleteByUserId(l);
    }

    @Override
    public Boolean isDepartmentHeader(Long l, Long l2) {
        List<DepartmentHeader> list = this.departmentHeaderDao.findByUserIdAndDepartmentId(l, l2);
        if (list != null && !list.isEmpty()) {
            return true;
        }
        return false;
    }

    @Override
    public List<UserVo> findHeaderByDepartmentId(Long l) {
        ArrayList<UserVo> arrayList = new ArrayList<UserVo>();
        List<DepartmentHeader> list = this.departmentHeaderDao.findByDepartmentId(l);
        list.forEach(departmentHeader -> {
            User user = (User)this.userDao.getOne(departmentHeader.getUserId());
            if (user != null) {
                arrayList.add(new UserVo().setId(user.getId()).setUsername(user.getUsername()).setNickname(user.getNickname()));
            }
        });
        return arrayList;
    }
}

