/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.common.serviceimpl;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import plus.hiver.common.dao.DepartmentDao;
import plus.hiver.common.entity.Department;
import plus.hiver.common.service.DepartmentService;
import plus.hiver.common.utils.SecurityUtil;

@Service
@Transactional
public class DepartmentServiceImpl
implements DepartmentService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DepartmentServiceImpl.class);
    @Autowired
    private DepartmentDao departmentDao;
    @Autowired
    private SecurityUtil securityUtil;

    public DepartmentDao getRepository() {
        return this.departmentDao;
    }

    @Override
    public List<Department> findByParentIdOrderBySortOrder(Long l, Boolean bl) {
        List<Long> list = this.securityUtil.getDeparmentIds();
        if (list != null && list.size() > 0 && bl.booleanValue()) {
            return this.departmentDao.findByParentIdAndIdInOrderBySortOrder(l, list);
        }
        return this.departmentDao.findByParentIdOrderBySortOrder(l);
    }

    @Override
    public List<Department> findByParentIdAndStatusOrderBySortOrder(Long l, Integer n) {
        return this.departmentDao.findByParentIdAndStatusOrderBySortOrder(l, n);
    }

    @Override
    public List<Department> findByTitleLikeOrderBySortOrder(String string, Boolean bl) {
        List<Long> list = this.securityUtil.getDeparmentIds();
        if (list != null && list.size() > 0 && bl.booleanValue()) {
            return this.departmentDao.findByTitleLikeAndIdInOrderBySortOrder(string, list);
        }
        return this.departmentDao.findByTitleLikeOrderBySortOrder(string);
    }

    @Override
    public List<Department> findDepartmentAllById(Long l) {
        ArrayList<Department> arrayList = new ArrayList<Department>();
        if (!"0".equals(l)) {
            Department department = (Department)this.departmentDao.getReferenceById(l);
            while (department != null) {
                arrayList.add(department);
                department = this.getNextParentId(department.getParentId());
            }
        }
        return arrayList;
    }

    @Override
    public List<Department> findByDeletedAndStatus(Integer n, Integer n2) {
        return this.departmentDao.findByDeletedAndStatus(n, n2);
    }

    @Override
    public List<Department> findByDeletedAndStatusAndParentId(Integer n, Integer n2, Long l) {
        return this.departmentDao.findByDeletedAndStatusAndParentId(n, n2, l);
    }

    private Department getNextParentId(Long l) {
        return (Department)this.departmentDao.getReferenceById(l);
    }
}

