/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.common.utils;

import cn.hutool.core.util.StrUtil;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import plus.hiver.common.constant.HiverConstant;
import plus.hiver.common.dao.DepartmentDao;
import plus.hiver.common.dto.PermissionDTO;
import plus.hiver.common.entity.Department;
import plus.hiver.common.entity.Role;
import plus.hiver.common.entity.User;
import plus.hiver.common.exception.HiverException;
import plus.hiver.common.redis.RedisTemplateHelper;
import plus.hiver.common.service.mybatis.IUserRoleService;
import plus.hiver.common.vo.TokenUser;

@Component
public class SecurityUtil {
    @Autowired
    private IUserRoleService iUserRoleService;
    @Autowired
    private DepartmentDao departmentDao;
    @Autowired
    private RedisTemplateHelper redisTemplate;

    public List<Long> getDeparmentIds() {
        ArrayList<Long> arrayList = new ArrayList();
        User user = this.getCurrUserSimple();
        String string = "userRole::depIds:" + user.getId();
        String string2 = this.redisTemplate.get(string);
        if (StrUtil.isNotBlank((CharSequence)string2)) {
            arrayList = (List)new Gson().fromJson(string2, new TypeToken<List<String>>(){}.getType());
            return arrayList;
        }
        List<Role> list = this.iUserRoleService.findByUserId(user.getId());
        Boolean bl = false;
        for (Role role : list) {
            if (role.getDataType() != null && !role.getDataType().equals(HiverConstant.DATA_TYPE_ALL)) continue;
            bl = true;
            break;
        }
        if (bl.booleanValue()) {
            return null;
        }
        for (Role role : list) {
            List<Long> list2;
            if (role.getDataType().equals(HiverConstant.DATA_TYPE_UNDER)) {
                if (user.getDepartmentId() == 0L) {
                    arrayList.add(-1L);
                    continue;
                }
                list2 = new ArrayList<Long>();
                this.getDepRecursion(user.getDepartmentId(), list2);
                arrayList.addAll(list2);
                continue;
            }
            if (role.getDataType().equals(HiverConstant.DATA_TYPE_SAME)) {
                if (user.getDepartmentId() == 0L) {
                    arrayList.add(-1L);
                    continue;
                }
                arrayList.add(user.getDepartmentId());
                continue;
            }
            if (role.getDataType().equals(HiverConstant.DATA_TYPE_CUSTOM)) {
                list2 = this.iUserRoleService.findDepIdsByUserId(user.getId());
                if (list2 == null || list2.size() == 0) {
                    arrayList.add(-1L);
                    continue;
                }
                arrayList.addAll(list2);
                continue;
            }
            if (!role.getDataType().equals(HiverConstant.DATA_TYPE_SELF)) continue;
            arrayList.add(-2L);
        }
        LinkedHashSet linkedHashSet = new LinkedHashSet(arrayList.size());
        linkedHashSet.addAll(arrayList);
        arrayList.clear();
        arrayList.addAll(linkedHashSet);
        this.redisTemplate.set(string, new Gson().toJson(arrayList), 15L, TimeUnit.DAYS);
        return arrayList;
    }

    public User getCurrUserSimple() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null || !authentication.isAuthenticated() || authentication.getName() == null || authentication instanceof AnonymousAuthenticationToken) {
            throw new HiverException("\u672a\u68c0\u6d4b\u5230\u767b\u5f55\u7528\u6237");
        }
        TokenUser tokenUser = (TokenUser)authentication.getPrincipal();
        User user = new User().setAppId(tokenUser.getAppId()).setUsername(tokenUser.getUsername()).setNickname(tokenUser.getNickname()).setMobile(tokenUser.getMobile()).setEmail(tokenUser.getEmail()).setDepartmentId(tokenUser.getDepartmentId()).setType(tokenUser.getType());
        if (tokenUser.getPermissions() != null && !tokenUser.getPermissions().isEmpty()) {
            user.setPermissions(tokenUser.getPermissions().stream().map(string -> new PermissionDTO().setTitle((String)string)).collect(Collectors.toList()));
        }
        user.setId(tokenUser.getId());
        return user;
    }

    private void getDepRecursion(Long l, List<Long> list) {
        Department department2 = (Department)this.departmentDao.getById(l);
        list.add(department2.getId());
        if (department2.getIsParent() != null && department2.getIsParent().booleanValue()) {
            List<Department> list2 = this.departmentDao.findByParentIdAndStatusOrderBySortOrder(l, HiverConstant.STATUS_NORMAL);
            list2.forEach(department -> this.getDepRecursion(department.getId(), list));
        }
    }
}

