/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.common.aop;

import cn.hutool.http.useragent.UserAgent;
import cn.hutool.http.useragent.UserAgentUtil;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.NamedThreadLocal;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Component;
import plus.hiver.common.annotation.SystemLog;
import plus.hiver.common.entity.Log;
import plus.hiver.common.entity.User;
import plus.hiver.common.service.LogService;
import plus.hiver.common.service.UserService;
import plus.hiver.common.utils.IpInfoUtil;
import plus.hiver.common.utils.ObjectUtil;
import plus.hiver.common.utils.ThreadPoolUtil;

@Aspect
@Component
public class SystemLogAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SystemLogAspect.class);
    private static final ThreadLocal<Date> THREAD_LOCAL_BEGIN_TIME = new NamedThreadLocal("ThreadLocal beginTime");
    @Resource
    private LogService logService;
    @Resource
    private HttpServletRequest request;
    @Resource
    private IpInfoUtil ipInfoUtil;
    @Resource
    private UserService userService;

    @Pointcut(value="@annotation(plus.hiver.common.annotation.SystemLog)")
    public void pointCut() {
    }

    @Around(value="pointCut()")
    public Object aroundMethod(ProceedingJoinPoint proceedingJoinPoint) {
        Object object;
        block9: {
            long l = new Date().getTime();
            try {
                object = proceedingJoinPoint.proceed();
                String string = "";
                Object object2 = "";
                String string2 = "PC\u7aef";
                String string3 = SystemLogAspect.getControllerMethodInfo((JoinPoint)proceedingJoinPoint).get("description").toString();
                int n = (Integer)SystemLogAspect.getControllerMethodInfo((JoinPoint)proceedingJoinPoint).get("type");
                Map map = this.request.getParameterMap();
                string = ((String[])map.get("username"))[0];
                User user = this.userService.findByUsernameOrEmailOrMobile(string, string, string);
                if (user != null) {
                    if (!new BCryptPasswordEncoder().matches((CharSequence)((String[])map.get("password"))[0], user.getPassword())) {
                        throw new Exception("\u5bc6\u7801\u9519\u8bef");
                    }
                    UserAgent userAgent = UserAgentUtil.parse((String)this.request.getHeader("user-agent"));
                    if (userAgent != null) {
                        if (userAgent.isMobile()) {
                            string2 = "\u79fb\u52a8\u7aef";
                        }
                        object2 = userAgent.getBrowser().toString() + " " + userAgent.getVersion() + " | " + userAgent.getPlatform().toString() + " " + userAgent.getOs().toString() + " | " + string2;
                    }
                    Log log = new Log();
                    log.setUsername(string);
                    log.setName(string3);
                    log.setLogType(n);
                    log.setRequestUrl(this.request.getRequestURI());
                    log.setRequestType(this.request.getMethod());
                    log.setMapToParams(map);
                    this.ipInfoUtil.getInfo(this.request, ObjectUtil.mapToStringAll(this.request.getParameterMap()));
                    log.setIp(IpInfoUtil.getIpAddr(this.request));
                    log.setIpInfo(this.ipInfoUtil.getIpCity(this.request));
                    log.setDevice((String)object2);
                    this.saveLog(log, l);
                    break block9;
                }
                throw new RuntimeException("\u7528\u6237\u4e0d\u5b58\u5728");
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
            finally {
                THREAD_LOCAL_BEGIN_TIME.remove();
            }
        }
        return object;
    }

    private void saveLog(Log log, long l) {
        long l2 = System.currentTimeMillis();
        Long l3 = l2 - l;
        log.setCostTime(l3.intValue());
        ThreadPoolUtil.getPool().execute(new SaveSystemLogThread(log, this.logService));
    }

    public static Map<String, Object> getControllerMethodInfo(JoinPoint joinPoint) throws ClassNotFoundException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(16);
        String string = joinPoint.getTarget().getClass().getName();
        String string2 = joinPoint.getSignature().getName();
        Object[] objectArray = joinPoint.getArgs();
        Class<?> clazz = Class.forName(string);
        Method[] methodArray = clazz.getMethods();
        String string3 = "";
        Integer n = null;
        for (Method method : methodArray) {
            Class<?>[] classArray;
            if (!method.getName().equals(string2) || (classArray = method.getParameterTypes()).length != objectArray.length) continue;
            string3 = method.getAnnotation(SystemLog.class).description();
            n = method.getAnnotation(SystemLog.class).type().ordinal();
            hashMap.put("description", string3);
            hashMap.put("type", n);
        }
        return hashMap;
    }

    private static class SaveSystemLogThread
    implements Runnable {
        private Log log;
        private LogService logService;

        public SaveSystemLogThread(Log log, LogService logService) {
            this.log = log;
            this.logService = logService;
        }

        @Override
        public void run() {
            this.logService.save(this.log);
        }
    }
}

