/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.common.base;

import io.swagger.v3.oas.annotations.Operation;
import java.io.Serializable;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import plus.hiver.common.api.Result;
import plus.hiver.common.base.HiverBaseService;
import plus.hiver.common.utils.PageUtil;
import plus.hiver.common.utils.ResultUtil;
import plus.hiver.common.vo.PageVo;

public abstract class HiverBaseController<E, ID extends Serializable> {
    public abstract HiverBaseService<E, ID> getService();

    @GetMapping(value={"/get/{id}"})
    @ResponseBody
    @Operation(summary="\u901a\u8fc7id\u83b7\u53d6")
    public Result<E> get(@PathVariable ID ID) {
        E e = this.getService().get(ID);
        return new ResultUtil<E>().setData(e);
    }

    @GetMapping(value={"/getAll"})
    @ResponseBody
    @Operation(summary="\u83b7\u53d6\u5168\u90e8\u6570\u636e")
    public Result<List<E>> getAll() {
        List<E> list = this.getService().getAll();
        return new ResultUtil<List<E>>().setData(list);
    }

    @GetMapping(value={"/getByPage"})
    @ResponseBody
    @Operation(summary="\u5206\u9875\u83b7\u53d6")
    public Result<Page<E>> getByPage(PageVo pageVo) {
        Page<E> page = this.getService().findAll(PageUtil.initPage(pageVo));
        return new ResultUtil<Page<E>>().setData(page);
    }

    @PostMapping(value={"/save"})
    @ResponseBody
    @Operation(summary="\u4fdd\u5b58\u6570\u636e")
    public Result<E> save(E e) {
        E e2 = this.getService().save(e);
        return new ResultUtil<E>().setData(e2);
    }

    @PutMapping(value={"/update"})
    @ResponseBody
    @Operation(summary="\u66f4\u65b0\u6570\u636e")
    public Result<E> update(E e) {
        E e2 = this.getService().update(e);
        return new ResultUtil<E>().setData(e2);
    }

    @PostMapping(value={"/delByIds"})
    @ResponseBody
    @Operation(summary="\u6279\u91cf\u901a\u8fc7id\u5220\u9664")
    public Result<Object> delByIds(ID[] IDArray) {
        for (ID ID : IDArray) {
            this.getService().delete(ID);
        }
        return ResultUtil.success("\u6279\u91cf\u901a\u8fc7id\u5220\u9664\u6570\u636e\u6210\u529f");
    }
}

