/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.common.base;

import java.io.Serializable;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.transaction.annotation.Transactional;
import plus.hiver.common.base.HiverBaseDao;
import plus.hiver.common.base.HiverBaseService;

@Transactional(readOnly=true)
public class HiverBaseServiceImpl<E, ID extends Serializable, D extends HiverBaseDao<E, ID>>
implements HiverBaseService<E, ID> {
    protected final D dao;

    public HiverBaseServiceImpl(D d) {
        this.dao = d;
    }

    @Override
    public E get(ID ID) {
        return this.findById(ID);
    }

    @Override
    public E findById(ID ID) {
        return this.dao.findById(ID).orElse(null);
    }

    @Override
    public List<E> getAll() {
        return this.dao.findAll();
    }

    @Override
    public Long getTotalCount() {
        return this.dao.findAll().size();
    }

    @Override
    public E save(E e) {
        return (E)this.dao.save(e);
    }

    @Override
    public E update(E e) {
        return (E)this.dao.saveAndFlush(e);
    }

    @Override
    public Iterable<E> saveOrUpdateAll(Iterable<E> iterable) {
        return this.dao.saveAll(iterable);
    }

    @Override
    public void delete(E e) {
        this.dao.delete(e);
    }

    @Override
    public void delete(ID ID) {
        this.dao.deleteById(ID);
    }

    @Override
    public void deleteAllById(Iterable<ID> iterable) {
        this.dao.deleteAllById(iterable);
    }

    @Override
    public void delete(Iterable<E> iterable) {
        this.dao.deleteAll(iterable);
    }

    @Override
    public void flush() {
        this.dao.flush();
    }

    @Override
    public List<E> findAll(Specification<E> specification) {
        return this.dao.findAll();
    }

    @Override
    public Page<E> findAll(Pageable pageable) {
        return this.dao.findAll(pageable);
    }

    @Override
    public Page<E> findAll(Specification<E> specification, Pageable pageable) {
        return this.dao.findAll(specification, pageable);
    }

    @Override
    public long count(Specification<E> specification) {
        return this.dao.findAll(specification).size();
    }
}

