/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.common.config.jpa;

import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.domain.AuditorAware;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import plus.hiver.common.config.security.SecurityUserDetails;

@Configuration
public class UserAuditor
implements AuditorAware<String> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserAuditor.class);

    public Optional<String> getCurrentAuditor() {
        try {
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            if (authentication != null && authentication.isAuthenticated() && !(authentication instanceof AnonymousAuthenticationToken)) {
                String string = authentication.getName();
                boolean bl = this.isCreateOperation();
                if (bl) {
                    Long l = this.extractUserId(authentication);
                    return Optional.of(String.format("%s|%d", string, l));
                }
                return Optional.of(string);
            }
            return Optional.empty();
        }
        catch (Exception exception) {
            log.warn("Failed to get current auditor: {}", (Object)exception.getMessage());
            return Optional.empty();
        }
    }

    private Long extractUserId(Authentication authentication) {
        if (authentication.getPrincipal() instanceof SecurityUserDetails) {
            return ((SecurityUserDetails)authentication.getPrincipal()).getId();
        }
        return 0L;
    }

    private boolean isCreateOperation() {
        return RequestContextHolder.getRequestAttributes() instanceof ServletRequestAttributes && ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest().getMethod().equalsIgnoreCase("POST");
    }
}

