/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.common.config.security.service;

import com.google.gson.Gson;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Service;
import plus.hiver.common.entity.User;
import plus.hiver.common.exception.CustomAuthenticationException;
import plus.hiver.common.redis.RedisTemplateHelper;
import plus.hiver.common.utils.JwtTokenUtil;
import plus.hiver.common.vo.TokenUser;

@Service
public class TokenValidationService {
    @Resource
    private RedisTemplateHelper redisTemplateHelper;

    public TokenUser validateToken(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getHeader("accessToken");
        if (string == null || !string.startsWith("Bearer ")) {
            throw new CustomAuthenticationException("\u8bf7\u5148\u767b\u9646");
        }
        String string2 = string.substring(7);
        if (JwtTokenUtil.isExpired(string2)) {
            throw new CustomAuthenticationException("\u8eab\u4efd\u9a8c\u8bc1\u8fc7\u671f");
        }
        String string3 = JwtTokenUtil.getUsername(string2);
        Long l = JwtTokenUtil.getUserId(string2);
        String string4 = this.redisTemplateHelper.get("HIVER_TOKEN_PRE:" + string);
        User user = (User)new Gson().fromJson(new Gson().toJson((Object)string4), User.class);
        return TokenUser.builder().userId(l).username(string3).token(string2).user(user).build();
    }
}

