/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.common.entity;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import plus.hiver.common.base.HiverBaseEntity;
import plus.hiver.common.constant.UserConstant;
import plus.hiver.common.dto.PermissionDTO;
import plus.hiver.common.dto.RoleDTO;

@Entity
@DynamicInsert
@DynamicUpdate
@Table(name="t_user")
@TableName(value="t_user")
@Tag(name="\u7528\u6237")
public class User
extends HiverBaseEntity
implements UserDetails {
    private static final long serialVersionUID = 1L;
    @Schema(description="\u6240\u5c5e\u5e94\u7528")
    private String appId;
    @Schema(description="\u767b\u5f55\u540d")
    @Column(unique=true, nullable=false)
    @Pattern(regexp="^[a-zA-Z0-9_]{1,16}$", message="\u767b\u5f55\u8d26\u53f7\u4e0d\u80fd\u5305\u542b\u4e2d\u6587\u3001\u7279\u6b8a\u5b57\u7b26 \u957f\u5ea6\u4e0d\u80fd>16")
    private @Pattern(regexp="^[a-zA-Z0-9_]{1,16}$", message="\u767b\u5f55\u8d26\u53f7\u4e0d\u80fd\u5305\u542b\u4e2d\u6587\u3001\u7279\u6b8a\u5b57\u7b26 \u957f\u5ea6\u4e0d\u80fd>16") String username;
    @Schema(description="\u5bc6\u7801")
    @NotNull(message="\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(message="\u4e0d\u80fd\u4e3a\u7a7a") String password;
    @Schema(description="\u7528\u6237\u540d/\u6635\u79f0/\u59d3\u540d")
    @Size(max=20, message="\u6635\u79f0\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc720")
    private @Size(max=20, message="\u6635\u79f0\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc720") String nickname;
    @Schema(description="\u624b\u673a")
    @Pattern(regexp="^[1][3,4,5,6,7,8,9][0-9]{9}$", message="11\u4f4d\u624b\u673a\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e")
    private @Pattern(regexp="^[1][3,4,5,6,7,8,9][0-9]{9}$", message="11\u4f4d\u624b\u673a\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e") String mobile;
    @Schema(description="\u90ae\u7bb1")
    @Pattern(regexp="^(([^<>()\\[\\]\\\\.,;:\\s@\"]+(\\.[^<>()\\[\\]\\\\.,;:\\s@\"]+)*)|(\".+\"))@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}])|(([a-zA-Z\\-0-9]+\\.)+[a-zA-Z]{2,}))$", message="\u90ae\u7bb1\u683c\u5f0f\u4e0d\u6b63\u786e")
    private @Pattern(regexp="^(([^<>()\\[\\]\\\\.,;:\\s@\"]+(\\.[^<>()\\[\\]\\\\.,;:\\s@\"]+)*)|(\".+\"))@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}])|(([a-zA-Z\\-0-9]+\\.)+[a-zA-Z]{2,}))$", message="\u90ae\u7bb1\u683c\u5f0f\u4e0d\u6b63\u786e") String email;
    @Schema(description="\u7701\u5e02\u53bf\u5730\u5740")
    private String address;
    @Schema(description="\u8857\u9053\u5730\u5740")
    private String street;
    @Schema(description="\u6027\u522b")
    private String sex;
    @Schema(description="\u5bc6\u7801\u5f3a\u5ea6")
    @Column(length=2)
    private String passStrength;
    @Schema(description="\u7528\u6237\u5934\u50cf")
    private String avatar = "https://ooo.0o0.ooo/2019/04/28/5cc5a71a6e3b6.png";
    @Schema(description="\u7528\u6237\u7c7b\u578b 0\u666e\u901a\u7528\u6237 1\u7ba1\u7406\u5458")
    private Integer type = UserConstant.USER_TYPE_NORMAL;
    @Schema(description="\u72b6\u6001 \u9ed8\u8ba40\u6b63\u5e38 -1\u62c9\u9ed1")
    private Integer status = UserConstant.USER_STATUS_NORMAL;
    @Schema(description="\u63cf\u8ff0/\u8be6\u60c5/\u5907\u6ce8")
    private String description;
    @Schema(description="\u6240\u5c5e\u90e8\u95e8id")
    private Long departmentId;
    @Schema(description="\u6240\u5c5e\u90e8\u95e8\u540d\u79f0")
    private String departmentTitle;
    @JsonFormat(timezone="GMT+8", pattern="yyyy-MM-dd")
    @DateTimeFormat(pattern="yyyy-MM-dd")
    @Schema(description="\u751f\u65e5")
    private Date birth;
    @Transient
    @TableField(exist=false)
    @Schema(description="\u7528\u6237\u62e5\u6709\u89d2\u8272")
    private List<RoleDTO> roles;
    @Transient
    @TableField(exist=false)
    @Schema(description="\u7528\u6237\u62e5\u6709\u7684\u6743\u9650")
    private List<PermissionDTO> permissions;
    @Transient
    @TableField(exist=false)
    @Schema(description="\u5bfc\u5165\u6570\u636e\u65f6\u4f7f\u7528")
    private Integer defaultRole;
    @Transient
    @TableField(exist=false)
    @Schema(description="\u7528\u6237\u6743\u9650\u5217\u8868")
    private List<GrantedAuthority> authorities;

    public Boolean hasRole(String string) {
        if (StrUtil.isBlank((CharSequence)string)) {
            return false;
        }
        for (RoleDTO roleDTO : this.roles) {
            if (!string.equals(roleDTO.getName())) continue;
            return true;
        }
        return false;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    @Generated
    public User setAppId(String string) {
        this.appId = string;
        return this;
    }

    @Generated
    public User setUsername(String string) {
        this.username = string;
        return this;
    }

    @Generated
    public User setPassword(String string) {
        this.password = string;
        return this;
    }

    @Generated
    public User setNickname(String string) {
        this.nickname = string;
        return this;
    }

    @Generated
    public User setMobile(String string) {
        this.mobile = string;
        return this;
    }

    @Generated
    public User setEmail(String string) {
        this.email = string;
        return this;
    }

    @Generated
    public User setAddress(String string) {
        this.address = string;
        return this;
    }

    @Generated
    public User setStreet(String string) {
        this.street = string;
        return this;
    }

    @Generated
    public User setSex(String string) {
        this.sex = string;
        return this;
    }

    @Generated
    public User setPassStrength(String string) {
        this.passStrength = string;
        return this;
    }

    @Generated
    public User setAvatar(String string) {
        this.avatar = string;
        return this;
    }

    @Generated
    public User setType(Integer n) {
        this.type = n;
        return this;
    }

    @Generated
    public User setStatus(Integer n) {
        this.status = n;
        return this;
    }

    @Generated
    public User setDescription(String string) {
        this.description = string;
        return this;
    }

    @Generated
    public User setDepartmentId(Long l) {
        this.departmentId = l;
        return this;
    }

    @Generated
    public User setDepartmentTitle(String string) {
        this.departmentTitle = string;
        return this;
    }

    @JsonFormat(timezone="GMT+8", pattern="yyyy-MM-dd")
    @Generated
    public User setBirth(Date date) {
        this.birth = date;
        return this;
    }

    @Generated
    public User setRoles(List<RoleDTO> list) {
        this.roles = list;
        return this;
    }

    @Generated
    public User setPermissions(List<PermissionDTO> list) {
        this.permissions = list;
        return this;
    }

    @Generated
    public User setDefaultRole(Integer n) {
        this.defaultRole = n;
        return this;
    }

    @Generated
    public User setAuthorities(List<GrantedAuthority> list) {
        this.authorities = list;
        return this;
    }

    @Generated
    public String getAppId() {
        return this.appId;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getNickname() {
        return this.nickname;
    }

    @Generated
    public String getMobile() {
        return this.mobile;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public String getAddress() {
        return this.address;
    }

    @Generated
    public String getStreet() {
        return this.street;
    }

    @Generated
    public String getSex() {
        return this.sex;
    }

    @Generated
    public String getPassStrength() {
        return this.passStrength;
    }

    @Generated
    public String getAvatar() {
        return this.avatar;
    }

    @Generated
    public Integer getType() {
        return this.type;
    }

    @Generated
    public Integer getStatus() {
        return this.status;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Long getDepartmentId() {
        return this.departmentId;
    }

    @Generated
    public String getDepartmentTitle() {
        return this.departmentTitle;
    }

    @Generated
    public Date getBirth() {
        return this.birth;
    }

    @Generated
    public List<RoleDTO> getRoles() {
        return this.roles;
    }

    @Generated
    public List<PermissionDTO> getPermissions() {
        return this.permissions;
    }

    @Generated
    public Integer getDefaultRole() {
        return this.defaultRole;
    }
}

