/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.common.redis;

import jakarta.annotation.Resource;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.stereotype.Component;

@Component
public class RedisTemplateHelper {
    @Resource
    private RedisTemplate<String, Object> redisTemplate;

    public Set<String> scan(String string) {
        return (Set)this.redisTemplate.execute(redisConnection -> {
            HashSet hashSet = new HashSet();
            ScanOptions scanOptions = ScanOptions.scanOptions().match(string).count(1000L).build();
            try (Cursor cursor = redisConnection.scan(scanOptions);){
                cursor.forEachRemaining(byArray -> hashSet.add(new String((byte[])byArray, StandardCharsets.UTF_8)));
            }
            return hashSet;
        }, false, true);
    }

    public String get(String string) {
        Object object = this.redisTemplate.opsForValue().get((Object)string);
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    public Long getExpire(String string) {
        return this.redisTemplate.getExpire((Object)string);
    }

    public Long getExpire(String string, TimeUnit timeUnit) {
        return this.redisTemplate.getExpire((Object)string, timeUnit);
    }

    public void set(String string, String string2) {
        this.redisTemplate.opsForValue().set((Object)string, (Object)string2);
    }

    public void set(String string, String string2, long l, TimeUnit timeUnit) {
        this.redisTemplate.opsForValue().set((Object)string, (Object)string2, l, timeUnit);
    }

    public void delete(String string) {
        this.redisTemplate.delete((Object)string);
    }

    public void deleteByPattern(String string) {
        Set<String> set = this.scan(string);
        this.redisTemplate.delete(set);
    }

    public RedisConnectionFactory getConnectionFactory() {
        return this.redisTemplate.getConnectionFactory();
    }
}

