/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.common.serviceimpl;

import cn.hutool.core.util.StrUtil;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import plus.hiver.common.base.HiverBaseServiceImpl;
import plus.hiver.common.dao.RoleDao;
import plus.hiver.common.entity.Role;
import plus.hiver.common.service.RoleService;

@Service
@Transactional
public class RoleServiceImpl
extends HiverBaseServiceImpl<Role, Long, RoleDao>
implements RoleService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RoleServiceImpl.class);

    public RoleServiceImpl(RoleDao roleDao) {
        super(roleDao);
    }

    @Override
    public List<Role> findByDefaultRole(Boolean bl) {
        return ((RoleDao)this.dao).findByDefaultRole(bl);
    }

    @Override
    public Page<Role> findByCondition(final String string, Pageable pageable) {
        return ((RoleDao)this.dao).findAll((Specification)new Specification<Role>(){

            @Nullable
            public Predicate toPredicate(Root<Role> root, CriteriaQuery<?> criteriaQuery, CriteriaBuilder criteriaBuilder) {
                Predicate predicate;
                Path path = root.get("name");
                Path path2 = root.get("description");
                ArrayList<Predicate> arrayList = new ArrayList<Predicate>();
                if (StrUtil.isNotBlank((CharSequence)string)) {
                    predicate = criteriaBuilder.like((Expression)path, "%" + string + "%");
                    Predicate predicate2 = criteriaBuilder.like((Expression)path2, "%" + string + "%");
                    arrayList.add(criteriaBuilder.or((Expression)predicate, (Expression)predicate2));
                }
                predicate = new Predicate[arrayList.size()];
                criteriaQuery.where((Predicate[])arrayList.toArray((T[])predicate));
                return null;
            }
        }, pageable);
    }

    @Override
    public List<Role> findByDeleted(Integer n) {
        return ((RoleDao)this.dao).findByDeleted(n);
    }
}

