/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.common.serviceimpl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.dfa.WordTree;
import jakarta.annotation.Nullable;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.ArrayList;
import java.util.Date;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import plus.hiver.common.base.HiverBaseServiceImpl;
import plus.hiver.common.dao.StopWordDao;
import plus.hiver.common.entity.StopWord;
import plus.hiver.common.service.StopWordService;
import plus.hiver.common.vo.SearchVo;

@Service
@Transactional
public class StopWordServiceImpl
extends HiverBaseServiceImpl<StopWord, Long, StopWordDao>
implements StopWordService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StopWordServiceImpl.class);
    private static WordTree wordTree;

    public StopWordServiceImpl(StopWordDao stopWordDao) {
        super(stopWordDao);
    }

    public WordTree getInstance() {
        if (wordTree == null) {
            wordTree = new WordTree();
            ((StopWordDao)this.dao).findAll().forEach(stopWord -> wordTree.addWord(stopWord.getTitle()));
        }
        return wordTree;
    }

    @Override
    public Page<StopWord> findByCondition(final StopWord stopWord, final SearchVo searchVo, Pageable pageable) {
        return ((StopWordDao)this.dao).findAll((Specification)new Specification<StopWord>(){

            @Nullable
            public Predicate toPredicate(Root<StopWord> root, CriteriaQuery<?> criteriaQuery, CriteriaBuilder criteriaBuilder) {
                DateTime dateTime;
                Path path = root.get("title");
                Path path2 = root.get("createTime");
                ArrayList<Predicate> arrayList = new ArrayList<Predicate>();
                if (StrUtil.isNotBlank((CharSequence)stopWord.getTitle())) {
                    arrayList.add(criteriaBuilder.like((Expression)path, "%" + stopWord.getTitle() + "%"));
                }
                if (StrUtil.isNotBlank((CharSequence)searchVo.getStartDate()) && StrUtil.isNotBlank((CharSequence)searchVo.getEndDate())) {
                    dateTime = DateUtil.parse((CharSequence)searchVo.getStartDate());
                    DateTime dateTime2 = DateUtil.parse((CharSequence)searchVo.getEndDate());
                    arrayList.add(criteriaBuilder.between((Expression)path2, (Comparable)dateTime, (Comparable)DateUtil.endOfDay((Date)dateTime2)));
                }
                dateTime = new Predicate[arrayList.size()];
                criteriaQuery.where(arrayList.toArray((T[])dateTime));
                return null;
            }
        }, pageable);
    }
}

