/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.common.utils;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.security.Keys;
import io.micrometer.common.lang.Nullable;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.crypto.SecretKey;
import org.springframework.util.StringUtils;
import plus.hiver.common.exception.HiverException;

public class JwtTokenUtil {
    private static final SecretKey key = Keys.hmacShaKeyFor((byte[])"Hiver-Auth-Server-Private-SecretKey".getBytes(StandardCharsets.UTF_8));
    private static final long tokenExpiration = 86400000L;
    private static final String subject = "Hiver";
    private static final Date time = new Date(System.currentTimeMillis() + 604800000L);

    public static String createTokenWithMap(Map<String, Object> map) {
        return Jwts.builder().subject(subject).expiration(time).signWith((Key)key).claims(map).id(UUID.randomUUID().toString()).compressWith(Jwts.ZIP.GZIP).compact();
    }

    public static String createTokenWithMap(Map<String, Object> map, Date date) {
        return Jwts.builder().subject(subject).signWith((Key)key).expiration(date).claims(map).id(UUID.randomUUID().toString()).compressWith(Jwts.ZIP.GZIP).compact();
    }

    public static String createTokenWithMap(Map<String, Object> map, Integer n) {
        return Jwts.builder().subject(subject).signWith((Key)key).expiration(new Date(System.currentTimeMillis() + 86400000L * (long)n.intValue())).claims(map).id(UUID.randomUUID().toString()).compressWith(Jwts.ZIP.GZIP).compact();
    }

    public static String createTokenWithMap(Map<String, Object> map, String string) {
        return Jwts.builder().subject(subject).expiration(time).signWith((Key)key).claims(map).id(UUID.randomUUID().toString()).compressWith(Jwts.ZIP.GZIP).compact();
    }

    public static String createTokenWithMap(Map<String, Object> map, String string, Date date) {
        return Jwts.builder().subject(string).expiration(date).claims(map).id(UUID.randomUUID().toString()).signWith((Key)key).compressWith(Jwts.ZIP.GZIP).compact();
    }

    public static String createTokenWithMap(Map<String, Object> map, String string, String string2) {
        return Jwts.builder().subject(string).expiration(time).claims(map).id(UUID.randomUUID().toString()).signWith((Key)key).compressWith(Jwts.ZIP.GZIP).compact();
    }

    public static String createTokenWithMap(Map<String, Object> map, String string, Integer n) {
        return Jwts.builder().subject(subject).expiration(new Date(System.currentTimeMillis() + 86400000L * (long)n.intValue())).claims(map).id(UUID.randomUUID().toString()).signWith((Key)key).compressWith(Jwts.ZIP.GZIP).compact();
    }

    public static String createTokenWithMap(Map<String, Object> map, String string, String string2, Integer n) {
        return Jwts.builder().subject(string).expiration(new Date(System.currentTimeMillis() + 86400000L * (long)n.intValue())).claims(map).id(UUID.randomUUID().toString()).signWith((Key)key).compressWith(Jwts.ZIP.GZIP).compact();
    }

    public static String createTokenWithMap(Map<String, Object> map, String string, String string2, Date date) {
        return Jwts.builder().subject(string).expiration(date).claims(map).id(UUID.randomUUID().toString()).signWith((Key)key).compressWith(Jwts.ZIP.GZIP).compact();
    }

    public static String createToken(Long l, String string, Integer n) {
        return Jwts.builder().subject(subject).expiration(new Date(System.currentTimeMillis() + 86400000L * (long)n.intValue())).claim("userId", (Object)l).claim("username", (Object)string).id(UUID.randomUUID().toString()).signWith((Key)key).compressWith(Jwts.ZIP.GZIP).compact();
    }

    public static Map<String, Object> getMapByToken(String string) {
        try {
            if (!StringUtils.hasText((String)string)) {
                throw new HiverException("token\u89e3\u6790\u5931\u8d25");
            }
            Claims claims = (Claims)Jwts.parser().verifyWith(key).build().parseSignedClaims((CharSequence)string).getPayload();
            return new HashMap<String, Object>((Map<String, Object>)claims);
        }
        catch (Exception exception) {
            throw new HiverException(exception.getMessage());
        }
    }

    public static Map<String, Object> getMapByToken(String string, String string2) {
        try {
            if (!StringUtils.hasText((String)string)) {
                throw new HiverException("token\u89e3\u6790\u5931\u8d25");
            }
            Jws jws = Jwts.parser().verifyWith(key).build().parseSignedClaims((CharSequence)string);
            Claims claims = (Claims)jws.getPayload();
            return new HashMap<String, Object>((Map<String, Object>)claims);
        }
        catch (Exception exception) {
            throw new HiverException(exception.getMessage());
        }
    }

    @Nullable
    private static String getSubjectByTokenHandler(String string) {
        try {
            if (!StringUtils.hasText((String)string)) {
                throw new HiverException("token\u89e3\u6790\u5931\u8d25");
            }
            Jws jws = Jwts.parser().verifyWith(key).build().parseSignedClaims((CharSequence)string);
            Claims claims = (Claims)jws.getPayload();
            return claims.getSubject();
        }
        catch (Exception exception) {
            throw new HiverException(exception.getMessage());
        }
    }

    public static String getSubjectByToken(String string) {
        return JwtTokenUtil.getSubjectByTokenHandler(string);
    }

    public static Long getUserId(String string) {
        try {
            if (!StringUtils.hasText((String)string)) {
                throw new HiverException("token\u89e3\u6790\u5931\u8d25");
            }
            Jws jws = Jwts.parser().verifyWith(key).build().parseSignedClaims((CharSequence)string);
            Claims claims = (Claims)jws.getPayload();
            return Long.valueOf(String.valueOf(claims.get((Object)"userId")));
        }
        catch (Exception exception) {
            throw new HiverException(exception.getMessage());
        }
    }

    public static String getUsername(String string) {
        try {
            if (!StringUtils.hasText((String)string)) {
                return "";
            }
            Jws jws = Jwts.parser().verifyWith(key).build().parseSignedClaims((CharSequence)string);
            Claims claims = (Claims)jws.getPayload();
            return (String)claims.get((Object)"username");
        }
        catch (Exception exception) {
            throw new HiverException(exception.getMessage());
        }
    }

    public static boolean isExpired(String string) {
        return JwtTokenUtil.isExpiredUtil(string);
    }

    private static boolean isExpiredUtil(String string) {
        try {
            Jws jws = Jwts.parser().verifyWith(key).build().parseSignedClaims((CharSequence)string);
            Date date = ((Claims)jws.getPayload()).getExpiration();
            return date != null && date.before(new Date());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return true;
        }
    }
}

