/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.common.vo;

import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.google.gson.Gson;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import plus.hiver.common.redis.RedisTemplateHelper;
import plus.hiver.common.utils.CommonUtil;
import plus.hiver.common.utils.IpInfoUtil;

@Schema(description="\u5728\u7ebf\u767b\u5f55\u7528\u6237\u4fe1\u606f")
public class OnlineUserVo {
    @Schema(description="\u4ee4\u724c")
    private String accessToken;
    @Schema(description="\u8d26\u53f7")
    private String username;
    @Schema(description="ip")
    private String ip;
    @Schema(description="ip\u4fe1\u606f")
    private String ipInfo;
    @Schema(description="\u8bbe\u5907\u4fe1\u606f")
    private String device;
    @JsonFormat(timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
    @Schema(description="\u7b2c\u4e00\u6b21\u6d3b\u8dc3\u65f6\u95f4")
    private Date firstActiveTime;
    @JsonFormat(timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
    @Schema(description="\u4e0a\u6b21\u6d3b\u8dc3\u65f6\u95f4")
    private Date lastActiveTime;
    @Schema(description="\u6301\u7eed\u6d3b\u8dc3\u65f6\u95f4\uff08\u5206\u949f\uff09")
    private Long activeTime;
    @Schema(description="\u662f\u5426JWT\u4ea4\u4e92\u4ee4\u724c")
    private Boolean isJWT;

    public OnlineUserVo() {
    }

    public OnlineUserVo(String string, String string2, Boolean bl, HttpServletRequest httpServletRequest) {
        Date date;
        this.accessToken = string;
        this.username = string2;
        this.ip = IpInfoUtil.getIpAddr(httpServletRequest);
        this.device = CommonUtil.getDeviceInfo(httpServletRequest);
        this.firstActiveTime = date = new Date();
        this.lastActiveTime = date;
        this.activeTime = 0L;
        this.isJWT = bl;
    }

    public static void update(String string, String string2, Boolean bl, RedisTemplateHelper redisTemplateHelper, HttpServletRequest httpServletRequest) {
        OnlineUserVo onlineUserVo;
        String string3 = bl != false ? "ONLINE_USER:" + string2 : "ONLINE_USER:" + string2 + ":" + string;
        String string4 = redisTemplateHelper.get(string3);
        if (StrUtil.isBlank((CharSequence)string4)) {
            onlineUserVo = new OnlineUserVo(string, string2, bl, httpServletRequest);
        } else {
            onlineUserVo = (OnlineUserVo)new Gson().fromJson(string4, OnlineUserVo.class);
            onlineUserVo.setIp(IpInfoUtil.getIpAddr(httpServletRequest));
            onlineUserVo.setDevice(CommonUtil.getDeviceInfo(httpServletRequest));
            onlineUserVo.setLastActiveTime(new Date());
            onlineUserVo.setActiveTime(DateUtil.between((Date)onlineUserVo.getFirstActiveTime(), (Date)onlineUserVo.getLastActiveTime(), (DateUnit)DateUnit.MINUTE));
        }
        redisTemplateHelper.set(string3, new Gson().toJson((Object)onlineUserVo), 30L, TimeUnit.MINUTES);
    }

    @Generated
    public String getAccessToken() {
        return this.accessToken;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getIp() {
        return this.ip;
    }

    @Generated
    public String getIpInfo() {
        return this.ipInfo;
    }

    @Generated
    public String getDevice() {
        return this.device;
    }

    @Generated
    public Date getFirstActiveTime() {
        return this.firstActiveTime;
    }

    @Generated
    public Date getLastActiveTime() {
        return this.lastActiveTime;
    }

    @Generated
    public Long getActiveTime() {
        return this.activeTime;
    }

    @Generated
    public Boolean getIsJWT() {
        return this.isJWT;
    }

    @Generated
    public OnlineUserVo setAccessToken(String string) {
        this.accessToken = string;
        return this;
    }

    @Generated
    public OnlineUserVo setUsername(String string) {
        this.username = string;
        return this;
    }

    @Generated
    public OnlineUserVo setIp(String string) {
        this.ip = string;
        return this;
    }

    @Generated
    public OnlineUserVo setIpInfo(String string) {
        this.ipInfo = string;
        return this;
    }

    @Generated
    public OnlineUserVo setDevice(String string) {
        this.device = string;
        return this;
    }

    @JsonFormat(timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
    @Generated
    public OnlineUserVo setFirstActiveTime(Date date) {
        this.firstActiveTime = date;
        return this;
    }

    @JsonFormat(timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
    @Generated
    public OnlineUserVo setLastActiveTime(Date date) {
        this.lastActiveTime = date;
        return this;
    }

    @Generated
    public OnlineUserVo setActiveTime(Long l) {
        this.activeTime = l;
        return this;
    }

    @Generated
    public OnlineUserVo setIsJWT(Boolean bl) {
        this.isJWT = bl;
        return this;
    }

    @Generated
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof OnlineUserVo)) {
            return false;
        }
        OnlineUserVo onlineUserVo = (OnlineUserVo)object;
        if (!onlineUserVo.canEqual(this)) {
            return false;
        }
        Long l = this.getActiveTime();
        Long l2 = onlineUserVo.getActiveTime();
        if (l == null ? l2 != null : !((Object)l).equals(l2)) {
            return false;
        }
        Boolean bl = this.getIsJWT();
        Boolean bl2 = onlineUserVo.getIsJWT();
        if (bl == null ? bl2 != null : !((Object)bl).equals(bl2)) {
            return false;
        }
        String string = this.getAccessToken();
        String string2 = onlineUserVo.getAccessToken();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        String string3 = this.getUsername();
        String string4 = onlineUserVo.getUsername();
        if (string3 == null ? string4 != null : !string3.equals(string4)) {
            return false;
        }
        String string5 = this.getIp();
        String string6 = onlineUserVo.getIp();
        if (string5 == null ? string6 != null : !string5.equals(string6)) {
            return false;
        }
        String string7 = this.getIpInfo();
        String string8 = onlineUserVo.getIpInfo();
        if (string7 == null ? string8 != null : !string7.equals(string8)) {
            return false;
        }
        String string9 = this.getDevice();
        String string10 = onlineUserVo.getDevice();
        if (string9 == null ? string10 != null : !string9.equals(string10)) {
            return false;
        }
        Date date = this.getFirstActiveTime();
        Date date2 = onlineUserVo.getFirstActiveTime();
        if (date == null ? date2 != null : !((Object)date).equals(date2)) {
            return false;
        }
        Date date3 = this.getLastActiveTime();
        Date date4 = onlineUserVo.getLastActiveTime();
        return !(date3 == null ? date4 != null : !((Object)date3).equals(date4));
    }

    @Generated
    protected boolean canEqual(Object object) {
        return object instanceof OnlineUserVo;
    }

    @Generated
    public int hashCode() {
        int n = 1;
        Long l = this.getActiveTime();
        n = n * 59 + (l == null ? 43 : ((Object)l).hashCode());
        Boolean bl = this.getIsJWT();
        n = n * 59 + (bl == null ? 43 : ((Object)bl).hashCode());
        String string = this.getAccessToken();
        n = n * 59 + (string == null ? 43 : string.hashCode());
        String string2 = this.getUsername();
        n = n * 59 + (string2 == null ? 43 : string2.hashCode());
        String string3 = this.getIp();
        n = n * 59 + (string3 == null ? 43 : string3.hashCode());
        String string4 = this.getIpInfo();
        n = n * 59 + (string4 == null ? 43 : string4.hashCode());
        String string5 = this.getDevice();
        n = n * 59 + (string5 == null ? 43 : string5.hashCode());
        Date date = this.getFirstActiveTime();
        n = n * 59 + (date == null ? 43 : ((Object)date).hashCode());
        Date date2 = this.getLastActiveTime();
        n = n * 59 + (date2 == null ? 43 : ((Object)date2).hashCode());
        return n;
    }

    @Generated
    public String toString() {
        return "OnlineUserVo(accessToken=" + this.getAccessToken() + ", username=" + this.getUsername() + ", ip=" + this.getIp() + ", ipInfo=" + this.getIpInfo() + ", device=" + this.getDevice() + ", firstActiveTime=" + String.valueOf(this.getFirstActiveTime()) + ", lastActiveTime=" + String.valueOf(this.getLastActiveTime()) + ", activeTime=" + this.getActiveTime() + ", isJWT=" + this.getIsJWT() + ")";
    }

    @Generated
    public OnlineUserVo(String string, String string2, String string3, String string4, String string5, Date date, Date date2, Long l, Boolean bl) {
        this.accessToken = string;
        this.username = string2;
        this.ip = string3;
        this.ipInfo = string4;
        this.device = string5;
        this.firstActiveTime = date;
        this.lastActiveTime = date2;
        this.activeTime = l;
        this.isJWT = bl;
    }
}

