/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.annotation;

import plus.hiver.common.enums.LogType;

import java.lang.annotation.*;

/**
 * 系统日志注解
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Target({ElementType.PARAMETER, ElementType.METHOD})//作用于参数或方法上
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface SystemLog {
    /**
     * 日志名称
     */
    String description() default "";

    /**
     * 日志类型
     */
    LogType type() default LogType.OPERATION;
}
