/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.config.security;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import plus.hiver.common.dao.UserDao;
import plus.hiver.common.entity.User;

/**
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Configuration
public class MethodSecurityConfig {
    /**
     * 设置密码校验器
     *
     * @return PasswordEncoder
     */
    @Bean
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

    /**
     * 使用数据库方式
     * 登录方式：邮箱+用户名
     *
     * @param userDao 获取用户数据
     * @return 数据库的用户
     */
    @Bean
    public UserDetailsService userDetailsService(UserDao userDao) {
        return username -> {
            // 根据邮箱查询用户名
            User user = userDao.findByUsernameOrEmailOrMobile(username, username, username);
            if (user == null) throw new UsernameNotFoundException("用户不存在");
            return user;
        };
    }
}
