/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.service;

import plus.hiver.common.base.HiverBaseService;
import plus.hiver.common.entity.User;
import plus.hiver.common.entity.UserRole;

import java.util.List;

/**
 * 用户角色接口
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
public interface UserRoleService extends HiverBaseService<UserRole, Long> {
    /**
     * 通过roleId查找
     */
    List<UserRole> findByRoleId(Long roleId);

    /**
     * 通过roleId查找用户
     */
    List<User> findUserByRoleId(Long roleId);

    /**
     * 删除用户角色
     */
    void deleteByUserId(Long userId);
}
