/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.common.config.mybatisplus;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import java.beans.PropertyEditor;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import plus.hiver.common.editors.DoubleEditor;
import plus.hiver.common.editors.IntegerEditor;
import plus.hiver.common.editors.LongEditor;

@Lazy
@RestControllerAdvice
@Configuration(proxyBeanMethods=false)
public class JsonAutoConfiguration {
    @Value(value="${spring.jackson.time-zone}")
    private String timeZone = "UTC+8";

    @InitBinder
    public void initBinder(WebDataBinder webDataBinder) {
        webDataBinder.registerCustomEditor(Date.class, (PropertyEditor)new CustomDateEditor(new DateFormat(){
            private final List<? extends DateFormat> DATE_FORMATS = Arrays.asList(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"), new SimpleDateFormat("yyyy-MM-dd HH:mm"), new SimpleDateFormat("yyyy-MM-dd"), new SimpleDateFormat("yyyy-MM"));

            @Override
            public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
                throw new UnsupportedOperationException("This custom date formatter can only be used to *parse* Dates.");
            }

            @Override
            public Date parse(String string, ParsePosition parsePosition) {
                for (DateFormat dateFormat : this.DATE_FORMATS) {
                    Date date = dateFormat.parse(string, parsePosition);
                    if (null == date) continue;
                    return date;
                }
                return null;
            }
        }, true));
        webDataBinder.registerCustomEditor(Long.class, (PropertyEditor)new LongEditor());
        webDataBinder.registerCustomEditor(Double.class, (PropertyEditor)new DoubleEditor());
        webDataBinder.registerCustomEditor(Integer.class, (PropertyEditor)new IntegerEditor());
    }

    @Bean
    public HttpMessageConverters jacksonHttpMessageConverters() {
        Jackson2ObjectMapperBuilder jackson2ObjectMapperBuilder = new Jackson2ObjectMapperBuilder();
        jackson2ObjectMapperBuilder.serializationInclusion(JsonInclude.Include.NON_NULL);
        jackson2ObjectMapperBuilder.featuresToEnable(new Object[]{MapperFeature.PROPAGATE_TRANSIENT_MARKER});
        ObjectMapper objectMapper = jackson2ObjectMapperBuilder.build();
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addSerializer(Long.class, (JsonSerializer)ToStringSerializer.instance);
        objectMapper.registerModule((Module)simpleModule);
        objectMapper.setTimeZone(TimeZone.getTimeZone(this.timeZone));
        MappingJackson2HttpMessageConverter mappingJackson2HttpMessageConverter = new MappingJackson2HttpMessageConverter(objectMapper);
        mappingJackson2HttpMessageConverter.setDefaultCharset(StandardCharsets.UTF_8);
        StringHttpMessageConverter stringHttpMessageConverter = new StringHttpMessageConverter(StandardCharsets.UTF_8);
        stringHttpMessageConverter.setDefaultCharset(StandardCharsets.UTF_8);
        return new HttpMessageConverters(new HttpMessageConverter[]{mappingJackson2HttpMessageConverter, stringHttpMessageConverter});
    }
}

