/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.common.config.security;

import cn.hutool.core.util.StrUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import plus.hiver.common.constant.UserConstant;
import plus.hiver.common.dto.PermissionDTO;
import plus.hiver.common.dto.RoleDTO;
import plus.hiver.common.entity.User;

public class SecurityUserDetails
extends User
implements UserDetails {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SecurityUserDetails.class);
    private static final long serialVersionUID = 1L;
    private List<PermissionDTO> permissions;
    private List<RoleDTO> roles;

    public SecurityUserDetails(User user) {
        if (user != null) {
            this.setId(user.getId());
            this.setAppId(user.getAppId());
            this.setUsername(user.getUsername());
            this.setPassword(user.getPassword());
            this.setStatus(user.getStatus());
            this.permissions = user.getPermissions();
            this.roles = user.getRoles();
        }
    }

    @Override
    public Collection<? extends GrantedAuthority> getAuthorities() {
        ArrayList<SimpleGrantedAuthority> arrayList = new ArrayList<SimpleGrantedAuthority>();
        if (this.permissions != null && this.permissions.size() > 0) {
            for (PermissionDTO permissionDTO : this.permissions) {
                if (!StrUtil.isNotBlank((CharSequence)permissionDTO.getTitle()) || !StrUtil.isNotBlank((CharSequence)permissionDTO.getPath())) continue;
                arrayList.add(new SimpleGrantedAuthority(permissionDTO.getTitle()));
            }
        }
        if (this.roles != null && this.roles.size() > 0) {
            this.roles.forEach(roleDTO -> {
                if (StrUtil.isNotBlank((CharSequence)roleDTO.getName())) {
                    arrayList.add(new SimpleGrantedAuthority(roleDTO.getName()));
                }
            });
        }
        return arrayList;
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return !UserConstant.USER_STATUS_LOCK.equals(this.getStatus());
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return UserConstant.USER_STATUS_NORMAL.equals(this.getStatus());
    }
}

