/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.common.config.security;

import lombok.Generated;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.config.annotation.method.configuration.EnableMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.util.matcher.RegexRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.cors.CorsConfiguration;
import plus.hiver.common.config.properties.IgnoredUrlsProperties;
import plus.hiver.common.config.security.handler.SecurityAccessDeniedHandler;
import plus.hiver.common.config.security.handler.SecurityAuthenticationEntryPoint;
import plus.hiver.common.config.security.service.CustomAuthorizationManagerServiceImpl;

@Configuration
@EnableWebSecurity
@EnableMethodSecurity(prePostEnabled=true)
public class WebSecurityConfig {
    private final IgnoredUrlsProperties ignoredUrlsProperties;
    private final CustomAuthorizationManagerServiceImpl customAuthorizationManagerService;
    public static String[] annotations;

    @Bean
    public SecurityFilterChain filterChain(HttpSecurity httpSecurity) throws Exception {
        annotations = this.ignoredUrlsProperties.getUrls();
        httpSecurity.httpBasic(AbstractHttpConfigurer::disable).formLogin(AbstractHttpConfigurer::disable).logout(AbstractHttpConfigurer::disable).csrf(AbstractHttpConfigurer::disable).cors(corsConfigurer -> corsConfigurer.configurationSource(httpServletRequest -> new CorsConfiguration().applyPermitDefaultValues())).sessionManagement(sessionManagementConfigurer -> sessionManagementConfigurer.sessionCreationPolicy(SessionCreationPolicy.STATELESS)).rememberMe(AbstractHttpConfigurer::disable).authorizeHttpRequests(authorizationManagerRequestMatcherRegistry -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizationManagerRequestMatcherRegistry.requestMatchers(annotations)).permitAll().requestMatchers(new RequestMatcher[]{RegexRequestMatcher.regexMatcher((String)".*\\.(css|js)$")})).permitAll().anyRequest()).access((AuthorizationManager)this.customAuthorizationManagerService)).exceptionHandling(exceptionHandlingConfigurer -> {
            exceptionHandlingConfigurer.authenticationEntryPoint((AuthenticationEntryPoint)new SecurityAuthenticationEntryPoint());
            exceptionHandlingConfigurer.accessDeniedHandler((AccessDeniedHandler)new SecurityAccessDeniedHandler());
        });
        return (SecurityFilterChain)httpSecurity.build();
    }

    @Generated
    public WebSecurityConfig(IgnoredUrlsProperties ignoredUrlsProperties, CustomAuthorizationManagerServiceImpl customAuthorizationManagerServiceImpl) {
        this.ignoredUrlsProperties = ignoredUrlsProperties;
        this.customAuthorizationManagerService = customAuthorizationManagerServiceImpl;
    }
}

