/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.common.serviceimpl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import jakarta.annotation.Resource;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import plus.hiver.common.base.HiverBaseServiceImpl;
import plus.hiver.common.constant.HiverConstant;
import plus.hiver.common.dao.UserDao;
import plus.hiver.common.dao.mapper.PermissionMapper;
import plus.hiver.common.dao.mapper.UserRoleMapper;
import plus.hiver.common.dto.PermissionDTO;
import plus.hiver.common.dto.RoleDTO;
import plus.hiver.common.entity.Permission;
import plus.hiver.common.entity.Role;
import plus.hiver.common.entity.User;
import plus.hiver.common.service.UserService;
import plus.hiver.common.utils.SecurityUtil;
import plus.hiver.common.vo.SearchVo;

@Service
@Transactional
@CacheConfig(cacheNames={"user"})
public class UserServiceImpl
extends HiverBaseServiceImpl<User, Long, UserDao>
implements UserService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserServiceImpl.class);
    private static final String CACHE_NAMES = "user";
    @Resource
    private UserRoleMapper userRoleMapper;
    @Resource
    private PermissionMapper permissionMapper;
    @Resource
    private SecurityUtil securityUtil;

    public UserServiceImpl(UserDao userDao) {
        super(userDao);
    }

    @Override
    public User findByUsername(String string) {
        User user = ((UserDao)this.dao).findByUsername(string);
        return this.userToDTO(user);
    }

    @Override
    public User findByMobile(String string) {
        User user = ((UserDao)this.dao).findByMobile(string);
        return this.userToDTO(user);
    }

    @Override
    public User findByEmail(String string) {
        User user = ((UserDao)this.dao).findByEmail(string);
        return this.userToDTO(user);
    }

    public User userToDTO(User user) {
        if (user == null) {
            return null;
        }
        List<Role> list = this.userRoleMapper.findByUserId(user.getId());
        List<RoleDTO> list2 = list.stream().map(role -> new RoleDTO().setId(role.getId()).setName(role.getName())).collect(Collectors.toList());
        user.setRoles(list2);
        List<Permission> list3 = this.permissionMapper.findByUserId(user.getId());
        List<PermissionDTO> list4 = list3.stream().filter(permission -> HiverConstant.PERMISSION_OPERATION.equals(permission.getType())).map(permission -> new PermissionDTO().setTitle(permission.getTitle()).setPath(permission.getPath())).collect(Collectors.toList());
        user.setPermissions(list4);
        return user;
    }

    @Override
    public Page<User> findByCondition(final User user, final SearchVo searchVo, Pageable pageable) {
        return ((UserDao)this.dao).findAll((Specification)new Specification<User>(){

            @Nullable
            public Predicate toPredicate(Root<User> root, CriteriaQuery<?> criteriaQuery, CriteriaBuilder criteriaBuilder) {
                DateTime dateTime;
                DateTime dateTime2;
                Path path = root.get("id");
                Path path2 = root.get("appId");
                Path path3 = root.get("username");
                Path path4 = root.get("nickname");
                Path path5 = root.get("mobile");
                Path path6 = root.get("email");
                Path path7 = root.get("departmentId");
                Path path8 = root.get("sex");
                Path path9 = root.get("type");
                Path path10 = root.get("status");
                Path path11 = root.get("createTime");
                ArrayList<Predicate> arrayList = new ArrayList<Predicate>();
                if (StrUtil.isNotBlank((CharSequence)user.getAppId())) {
                    arrayList.add(criteriaBuilder.equal((Expression)path2, (Object)user.getAppId()));
                }
                if (StrUtil.isNotBlank((CharSequence)user.getUsername())) {
                    arrayList.add(criteriaBuilder.like((Expression)path3, "%" + user.getUsername() + "%"));
                }
                if (StrUtil.isNotBlank((CharSequence)user.getNickname())) {
                    arrayList.add(criteriaBuilder.like((Expression)path4, "%" + user.getNickname() + "%"));
                }
                if (StrUtil.isNotBlank((CharSequence)user.getMobile())) {
                    arrayList.add(criteriaBuilder.like((Expression)path5, "%" + user.getMobile() + "%"));
                }
                if (StrUtil.isNotBlank((CharSequence)user.getEmail())) {
                    arrayList.add(criteriaBuilder.like((Expression)path6, "%" + user.getEmail() + "%"));
                }
                if (user.getDepartmentId() != null && user.getDepartmentId() > 0L) {
                    arrayList.add(criteriaBuilder.equal((Expression)path7, (Object)user.getDepartmentId()));
                }
                if (StrUtil.isNotBlank((CharSequence)user.getSex())) {
                    arrayList.add(criteriaBuilder.equal((Expression)path8, (Object)user.getSex()));
                }
                if (user.getType() != null) {
                    arrayList.add(criteriaBuilder.equal((Expression)path9, (Object)user.getType()));
                }
                if (user.getStatus() != null) {
                    arrayList.add(criteriaBuilder.equal((Expression)path10, (Object)user.getStatus()));
                }
                if (StrUtil.isNotBlank((CharSequence)searchVo.getStartDate()) && StrUtil.isNotBlank((CharSequence)searchVo.getEndDate())) {
                    dateTime2 = DateUtil.parse((CharSequence)searchVo.getStartDate());
                    dateTime = DateUtil.parse((CharSequence)searchVo.getEndDate());
                    arrayList.add(criteriaBuilder.between((Expression)path11, (Comparable)dateTime2, (Comparable)DateUtil.endOfDay((Date)dateTime)));
                }
                if ((dateTime2 = UserServiceImpl.this.securityUtil.getDeparmentIds()) != null && dateTime2.size() > 0) {
                    arrayList.add(path7.in((Collection)dateTime2));
                }
                dateTime = new Predicate[arrayList.size()];
                criteriaQuery.where((Predicate[])arrayList.toArray((T[])dateTime));
                return null;
            }
        }, pageable);
    }

    @Override
    public List<User> findByDepartmentId(Long l) {
        return ((UserDao)this.dao).findByDepartmentId(l);
    }

    @Override
    public List<User> findByUsernameLikeAndStatus(String string, Integer n) {
        return ((UserDao)this.dao).findByUsernameLikeAndStatus(string, n);
    }

    @Override
    public void updateDepartmentTitle(Long l, String string) {
        ((UserDao)this.dao).updateDepartmentTitle(l, string);
    }

    @Override
    public List<User> findByDeletedAndStatusAndDepartmentId(Integer n, Integer n2, Long l) {
        return ((UserDao)this.dao).findByDeletedAndStatusAndDepartmentId(n, n2, l);
    }

    @Override
    public List<User> findByAll(final User user) {
        return ((UserDao)this.dao).findAll((Specification)new Specification<User>(){

            @Nullable
            public Predicate toPredicate(Root<User> root, CriteriaQuery<?> criteriaQuery, CriteriaBuilder criteriaBuilder) {
                List<Long> list;
                Path path = root.get("id");
                Path path2 = root.get("appId");
                Path path3 = root.get("username");
                Path path4 = root.get("nickname");
                Path path5 = root.get("mobile");
                Path path6 = root.get("email");
                Path path7 = root.get("departmentId");
                Path path8 = root.get("sex");
                Path path9 = root.get("type");
                Path path10 = root.get("status");
                Path path11 = root.get("createTime");
                ArrayList<Predicate> arrayList = new ArrayList<Predicate>();
                if (user.getId() > 0L) {
                    arrayList.add(criteriaBuilder.equal((Expression)path, (Object)user.getId()));
                }
                if (StrUtil.isNotBlank((CharSequence)user.getAppId())) {
                    arrayList.add(criteriaBuilder.equal((Expression)path2, (Object)user.getAppId()));
                }
                if (StrUtil.isNotBlank((CharSequence)user.getUsername())) {
                    arrayList.add(criteriaBuilder.like((Expression)path3, "%" + user.getUsername() + "%"));
                }
                if (StrUtil.isNotBlank((CharSequence)user.getNickname())) {
                    arrayList.add(criteriaBuilder.like((Expression)path4, "%" + user.getNickname() + "%"));
                }
                if (StrUtil.isNotBlank((CharSequence)user.getMobile())) {
                    arrayList.add(criteriaBuilder.like((Expression)path5, "%" + user.getMobile() + "%"));
                }
                if (StrUtil.isNotBlank((CharSequence)user.getEmail())) {
                    arrayList.add(criteriaBuilder.like((Expression)path6, "%" + user.getEmail() + "%"));
                }
                if (user.getDepartmentId() > 0L) {
                    arrayList.add(criteriaBuilder.equal((Expression)path7, (Object)user.getDepartmentId()));
                }
                if (StrUtil.isNotBlank((CharSequence)user.getSex())) {
                    arrayList.add(criteriaBuilder.equal((Expression)path8, (Object)user.getSex()));
                }
                if (user.getType() != null) {
                    arrayList.add(criteriaBuilder.equal((Expression)path9, (Object)user.getType()));
                }
                if (user.getStatus() != null) {
                    arrayList.add(criteriaBuilder.equal((Expression)path10, (Object)user.getStatus()));
                }
                if ((list = UserServiceImpl.this.securityUtil.getDeparmentIds()) != null && list.size() > 0) {
                    arrayList.add(path7.in(list));
                }
                Predicate[] predicateArray = new Predicate[arrayList.size()];
                criteriaQuery.where(arrayList.toArray(predicateArray));
                return null;
            }
        });
    }

    @Override
    public User findByUsernameOrEmailOrMobile(String string, String string2, String string3) {
        return ((UserDao)this.dao).findByUsernameOrEmailOrMobile(string, string2, string3);
    }
}

