/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.common.utils;

import java.lang.management.ManagementFactory;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Random;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;

public class DateUtil
extends DateUtils {
    public static String YYYY = "yyyy";
    public static String YYYY_MM = "yyyy-MM";
    public static String YYYY_MM_DD = "yyyy-MM-dd";
    public static String YYYYMMDDHHMMSS = "yyyyMMddHHmmss";
    public static String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static String SS_MM_HH_DD_HH_YY = "ssmmHHddMMyy";
    public static String YY_MM_DD_HH_MM_SS = "yy-MM-dd HH:mm:ss";
    private static String[] parsePatterns = new String[]{"yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM", "yyyy/MM/dd", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm", "yyyy/MM", "yyyy.MM.dd", "yyyy.MM.dd HH:mm:ss", "yyyy.MM.dd HH:mm", "yyyy.MM"};

    public static Date getNowDate() {
        return new Date();
    }

    public static String getDate() {
        return DateUtil.dateTimeNow(YYYY_MM_DD);
    }

    public static final String getTime() {
        return DateUtil.dateTimeNow(YYYY_MM_DD_HH_MM_SS);
    }

    public static final String dateTimeNow() {
        return DateUtil.dateTimeNow(YYYYMMDDHHMMSS);
    }

    public static final String dateTimeNow(String string) {
        return DateUtil.parseDateToStr(string, new Date());
    }

    public static final String dateTime(Date date) {
        return DateUtil.parseDateToStr(YYYY_MM_DD, date);
    }

    public static final String parseDateToStr(String string, Date date) {
        return new SimpleDateFormat(string).format(date);
    }

    public static final Date dateTime(String string, String string2) {
        try {
            return new SimpleDateFormat(string).parse(string2);
        }
        catch (ParseException parseException) {
            throw new RuntimeException(parseException);
        }
    }

    public static final String datePath() {
        Date date = new Date();
        return DateFormatUtils.format((Date)date, (String)"yyyy/MM/dd");
    }

    public static final String dateTime() {
        Date date = new Date();
        return DateFormatUtils.format((Date)date, (String)"yyyyMMdd");
    }

    public static final String dateTimeYY(Date date) {
        return DateFormatUtils.format((Date)date, (String)YY_MM_DD_HH_MM_SS);
    }

    public static Date parseDate(Object object) {
        if (object == null) {
            return null;
        }
        try {
            return DateUtil.parseDate((String)object.toString(), (String[])parsePatterns);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public static Date getServerStartDate() {
        long l = ManagementFactory.getRuntimeMXBean().getStartTime();
        return new Date(l);
    }

    public static int differentDaysByMillisecond(Date date, Date date2) {
        return Math.abs((int)((date2.getTime() - date.getTime()) / 86400000L));
    }

    public static String timeDistance(Date date, Date date2) {
        long l = 86400000L;
        long l2 = 3600000L;
        long l3 = 60000L;
        long l4 = date.getTime() - date2.getTime();
        long l5 = l4 / l;
        long l6 = l4 % l / l2;
        long l7 = l4 % l % l2 / l3;
        return l5 + "\u5929" + l6 + "\u5c0f\u65f6" + l7 + "\u5206\u949f";
    }

    public static Date toDate(LocalDateTime localDateTime) {
        ZonedDateTime zonedDateTime = localDateTime.atZone(ZoneId.systemDefault());
        return Date.from(zonedDateTime.toInstant());
    }

    public static Date toDate(LocalDate localDate) {
        LocalDateTime localDateTime = LocalDateTime.of(localDate, LocalTime.of(0, 0, 0));
        ZonedDateTime zonedDateTime = localDateTime.atZone(ZoneId.systemDefault());
        return Date.from(zonedDateTime.toInstant());
    }

    public static long getTimestamp() {
        return System.currentTimeMillis();
    }

    public static long getTimestampSeconds() {
        return System.currentTimeMillis() / 1000L;
    }

    public static String generateRandomHex(int n) {
        Random random = new Random();
        StringBuilder stringBuilder = new StringBuilder(n);
        stringBuilder.append("D");
        for (int i = 1; i < n; ++i) {
            int n2 = random.nextInt(16);
            char c = Character.toUpperCase(Character.forDigit(n2, 16));
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) {
        Date date = DateUtil.dateTime(SS_MM_HH_DD_HH_YY, "434123181121");
        String string = DateUtil.dateTimeYY(date);
        System.out.println(string);
        String string2 = DateUtil.generateRandomHex(12);
        System.out.println(string2);
    }
}

