/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.common.utils;

import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import plus.hiver.common.entity.User;
import plus.hiver.common.exception.HiverException;
import plus.hiver.common.service.UserService;

public class NameUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NameUtil.class);
    private static UserService userService = (UserService)SpringUtil.getBean(UserService.class);
    public static final String regUsername = "^[a-zA-Z0-9_]{1,16}$";
    public static final String regMobile = "^[1][3,4,5,6,7,8,9][0-9]{9}$";
    public static final String regEmail = "^(([^<>()\\[\\]\\\\.,;:\\s@\"]+(\\.[^<>()\\[\\]\\\\.,;:\\s@\"]+)*)|(\".+\"))@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}])|(([a-zA-Z\\-0-9]+\\.)+[a-zA-Z]{2,}))$";
    private static final Pattern pUsername = Pattern.compile("^[a-zA-Z0-9_]{1,16}$");
    private static final Pattern pMobile = Pattern.compile("^[1][3,4,5,6,7,8,9][0-9]{9}$");
    private static final Pattern pEmail = Pattern.compile("^(([^<>()\\[\\]\\\\.,;:\\s@\"]+(\\.[^<>()\\[\\]\\\\.,;:\\s@\"]+)*)|(\".+\"))@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}])|(([a-zA-Z\\-0-9]+\\.)+[a-zA-Z]{2,}))$");

    public static boolean username(String string) {
        if (StrUtil.isBlank((CharSequence)string)) {
            return false;
        }
        Matcher matcher = pUsername.matcher(string);
        return matcher.matches();
    }

    public static boolean mobile(String string) {
        if (StrUtil.isBlank((CharSequence)string)) {
            return false;
        }
        Matcher matcher = pMobile.matcher(string);
        return matcher.matches();
    }

    public static boolean email(String string) {
        if (StrUtil.isBlank((CharSequence)string)) {
            return false;
        }
        Matcher matcher = pEmail.matcher(string);
        return matcher.matches();
    }

    public static void checkUserInfo(User user) {
        if (user == null) {
            throw new HiverException("user\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String string = user.getUsername();
        String string2 = user.getMobile();
        String string3 = user.getEmail();
        if (NameUtil.mobile(string) && !string.equals(string2)) {
            throw new HiverException("\u767b\u5f55\u8d26\u53f7\u4e0d\u80fd\u4e3a\u4ed6\u4eba\u624b\u673a\u53f7");
        }
        if (StrUtil.isNotBlank((CharSequence)string) && userService.findByUsername(string) != null) {
            throw new HiverException("\u8be5\u767b\u5f55\u8d26\u53f7\u5df2\u88ab\u6ce8\u518c");
        }
        if (StrUtil.isNotBlank((CharSequence)string3) && userService.findByEmail(string3) != null) {
            throw new HiverException("\u8be5\u90ae\u7bb1\u5df2\u88ab\u6ce8\u518c");
        }
        if (StrUtil.isNotBlank((CharSequence)string2) && userService.findByMobile(string2) != null) {
            throw new HiverException("\u8be5\u624b\u673a\u53f7\u5df2\u88ab\u6ce8\u518c");
        }
    }
}

