/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.api;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;

/**
 * REST API 返回结果
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Data
public class Result<T> implements Serializable {
    private static final long serialVersionUID = 1L;

    public Result() {
    }

    public Result(String message, Integer code) {
        this.code = code;
        this.message = message;
    }

    public Result(T data, String message, Integer code) {
        this.result = data;
        this.code = code;
        this.message = message;
    }

    @Schema(description = "成功标志")
    private boolean success;

    @Schema(description = "消息")
    private String message;

    @Schema(description = "返回代码")
    private Integer code;

    @Schema(description = "时间戳")
    private long timestamp = System.currentTimeMillis();

    @Schema(description = "结果对象")
    private T result;
}
