/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.config.sm2;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

/**
 * SM2配置
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Data
@Configuration
@ConfigurationProperties(prefix = "sm2")
public class Sm2Config {
    private Boolean enabled = true;

    private String publicKey;

    private String privateKey;
}
