/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import plus.hiver.common.base.HiverBaseEntity;
import plus.hiver.common.constant.HiverConstant;

/**
 * 部门负责实体类
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Data
@Entity
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Table(name = "t_department_header")
@TableName("t_department_header")
@Tag(name = "部门负责人")
public class DepartmentHeader extends HiverBaseEntity {
    private static final long serialVersionUID = 1L;

    @Schema(description = "关联部门id")
    private Long departmentId;

    @Schema(description = "关联部门负责人")
    private Long userId;

    @Schema(description = "负责人类型 默认0主要 1副职")
    private Integer type = HiverConstant.HEADER_TYPE_MAIN;
}
