/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.service;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import plus.hiver.common.base.HiverBaseService;
import plus.hiver.common.entity.User;
import plus.hiver.common.vo.SearchVo;

import java.util.List;

/**
 * 用户接口
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
public interface UserService extends HiverBaseService<User, Long> {
    /**
     * 通过用户名获取用户
     */
    User findByUsername(String username);

    /**
     * 通过手机获取用户
     */
    User findByMobile(String mobile);

    /**
     * 通过邮件和状态获取用户
     */
    User findByEmail(String email);

    /**
     * 多条件分页获取用户
     */
    Page<User> findByCondition(User user, SearchVo searchVo, Pageable pageable);

    /**
     * 通过部门id获取
     */
    List<User> findByDepartmentId(Long departmentId);

    /**
     * 通过用户名模糊搜索
     */
    List<User> findByUsernameLikeAndStatus(String username, Integer status);

    /**
     * 更新部门名称
     */
    void updateDepartmentTitle(Long departmentId, String departmentTitle);

    /**
     * 通过部门获得员工列表
     */
    List<User> findByDeletedAndStatusAndDepartmentId(Integer deleted, Integer status, Long departmentId);

    /**
     * 通过条件获得用户列表
     */
    List<User> findByAll(User user);

    /**
     * 搜索用户
     *
     * @param username
     * @param email
     * @param mobile
     * @return
     */
    User findByUsernameOrEmailOrMobile(String username, String email, String mobile);
}
