/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.common.aop;

import jakarta.annotation.Resource;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import lombok.Generated;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;
import plus.hiver.common.annotation.Decrypt;
import plus.hiver.common.config.sm2.impl.Sm2ServiceImpl;

@Aspect
@Component
public class SecurityAspect {
    @Resource
    private Sm2ServiceImpl sm2Service;

    @Around(value="@within(plus.hiver.common.annotation.NoAuth) || @annotation(plus.hiver.common.annotation.NoAuth)")
    public Object noAuthCheck(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        return proceedingJoinPoint.proceed();
    }

    @Around(value="!@within(plus.hiver.common.annotation.NoAuth) && !@annotation(plus.hiver.common.annotation.NoAuth) && (execution(* plus.hiver..controller..*.*(..)))")
    public Object authCheck(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        if (!this.sm2Service.isEnabled()) {
            return proceedingJoinPoint.proceed();
        }
        Object[] objectArray = proceedingJoinPoint.getArgs();
        MethodSignature methodSignature = (MethodSignature)proceedingJoinPoint.getSignature();
        Method method = methodSignature.getMethod();
        Parameter[] parameterArray = method.getParameters();
        for (int i = 0; i < parameterArray.length; ++i) {
            if (!parameterArray[i].isAnnotationPresent(Decrypt.class) || !(objectArray[i] instanceof String)) continue;
            objectArray[i] = this.sm2Service.decrypt((String)objectArray[i]);
        }
        return proceedingJoinPoint.proceed(objectArray);
    }

    @Generated
    public SecurityAspect() {
    }
}

