/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.common.api;

import java.util.Objects;
import java.util.function.Supplier;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.util.ObjectUtils;
import plus.hiver.common.api.IErrorCode;
import plus.hiver.common.exception.HiverException;

public class ApiAssert {
    protected ApiAssert() {
    }

    public static void fail(IErrorCode iErrorCode) {
        throw new HiverException(iErrorCode);
    }

    public static void fail(boolean bl, IErrorCode iErrorCode) {
        if (bl) {
            ApiAssert.fail(iErrorCode);
        }
    }

    public static void fail(String string) {
        throw new HiverException(string);
    }

    public static void fail(boolean bl, Supplier<String> supplier) {
        ApiAssert.fail(bl, supplier.get());
    }

    public static void fail(boolean bl, String string) {
        if (bl) {
            ApiAssert.fail(string);
        }
    }

    public static void isEmpty(Object object, String string) {
        ApiAssert.fail(ObjectUtils.isEmpty((Object)object), string);
    }

    public static void nonEmpty(Object object, String string) {
        ApiAssert.fail(!ObjectUtils.isEmpty((Object)object), string);
    }

    public static void equals(Object object, Object object2, String string) {
        ApiAssert.fail(Objects.equals(object, object2), string);
    }

    public static void nonEquals(Object object, Object object2, String string) {
        ApiAssert.fail(!Objects.equals(object, object2), string);
    }

    public static void fail(String string, MessageSource messageSource) {
        ApiAssert.fail(messageSource.getMessage(string, null, LocaleContextHolder.getLocale()));
    }

    public static void fail(boolean bl, String string, MessageSource messageSource) {
        if (bl) {
            ApiAssert.fail(string, messageSource);
        }
    }

    public static void fail(String string, Object[] objectArray, MessageSource messageSource) {
        ApiAssert.fail(messageSource.getMessage(string, objectArray, LocaleContextHolder.getLocale()));
    }

    public static void fail(boolean bl, String string, Object[] objectArray, MessageSource messageSource) {
        if (bl) {
            ApiAssert.fail(string, objectArray, messageSource);
        }
    }
}

