/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.common.config.security.service;

import cn.hutool.core.util.StrUtil;
import com.google.gson.Gson;
import io.jsonwebtoken.ExpiredJwtException;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import plus.hiver.common.config.properties.HiverTokenProperties;
import plus.hiver.common.dto.PermissionDTO;
import plus.hiver.common.exception.CustomAuthenticationException;
import plus.hiver.common.redis.RedisTemplateHelper;
import plus.hiver.common.utils.JwtTokenUtil;
import plus.hiver.common.utils.ResponseUtil;
import plus.hiver.common.utils.SecurityUtil;
import plus.hiver.common.vo.OnlineUserVo;
import plus.hiver.common.vo.TokenUser;

@Service
public class TokenValidationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TokenValidationService.class);
    @Resource
    private HiverTokenProperties tokenProperties;
    @Resource
    private RedisTemplateHelper redisTemplateHelper;
    @Resource
    private SecurityUtil securityUtil;

    public TokenUser validateToken(HttpServletRequest httpServletRequest) {
        String string;
        TokenUser tokenUser = null;
        List<Object> list = new ArrayList();
        String string2 = httpServletRequest.getHeader("accessToken");
        if (string2 != null && !string2.startsWith("Bearer ")) {
            throw new CustomAuthenticationException("\u8bf7\u5148\u767b\u9646");
        }
        if (this.tokenProperties.getRedis().booleanValue()) {
            string = this.redisTemplateHelper.get("HIVER_TOKEN_PRE:" + (string2 = string2.replace("Bearer ", "")));
            if (StrUtil.isBlank((CharSequence)string)) {
                ResponseUtil.resultMap(false, 401, "\u4f1a\u5458\u767b\u5f55\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
                return null;
            }
            tokenUser = (TokenUser)new Gson().fromJson(string, TokenUser.class);
            if (this.tokenProperties.getStorePerms().booleanValue()) {
                for (PermissionDTO permissionDTO : tokenUser.getPermissions()) {
                    list.add(new SimpleGrantedAuthority(permissionDTO.getPath()));
                }
            } else {
                list = this.securityUtil.getCurrUserPerms(tokenUser.getUsername());
            }
            if (!tokenUser.getSaveLogin().booleanValue()) {
                this.redisTemplateHelper.set("HIVER_USER_TOKEN:" + tokenUser.getUsername(), string2, this.tokenProperties.getTokenExpireTime().intValue(), TimeUnit.MINUTES);
                this.redisTemplateHelper.set("HIVER_TOKEN_PRE:" + string2, string, this.tokenProperties.getTokenExpireTime().intValue(), TimeUnit.MINUTES);
            }
            OnlineUserVo.update(string2, tokenUser.getUsername(), false, this.redisTemplateHelper, httpServletRequest);
        } else {
            try {
                string = string2.substring(7);
                if (JwtTokenUtil.isExpired(string)) {
                    throw new CustomAuthenticationException("\u8eab\u4efd\u9a8c\u8bc1\u8fc7\u671f");
                }
                String string3 = JwtTokenUtil.getUsername(string);
                Long l = JwtTokenUtil.getUserId(string);
                String string4 = this.redisTemplateHelper.get("HIVER_TOKEN_PRE:" + string);
                tokenUser = (TokenUser)new Gson().fromJson(string4, TokenUser.class);
                list = this.securityUtil.getCurrUserPerms(tokenUser.getUsername());
                OnlineUserVo.update(string2, tokenUser.getUsername(), true, this.redisTemplateHelper, httpServletRequest);
            }
            catch (ExpiredJwtException expiredJwtException) {
                ResponseUtil.resultMap(false, 401, "\u767b\u5f55\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
            }
            catch (Exception exception) {
                log.error(exception.toString());
                ResponseUtil.resultMap(false, 500, "\u89e3\u6790token\u9519\u8bef");
            }
        }
        if (tokenUser != null && StrUtil.isNotBlank((CharSequence)tokenUser.getUsername())) {
            string = new UsernamePasswordAuthenticationToken((Object)tokenUser, null, list);
            SecurityContextHolder.getContext().setAuthentication((Authentication)string);
            return tokenUser;
        }
        return null;
    }
}

