/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.common.config.sm2.impl;

import jakarta.annotation.Resource;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.springframework.stereotype.Service;
import plus.hiver.common.config.sm2.Sm2Config;
import plus.hiver.common.config.sm2.Sm2Service;
import plus.hiver.common.utils.SM2Util;

@Service
public class Sm2ServiceImpl
implements Sm2Service {
    @Resource
    Sm2Config sm2config;

    @Override
    public String encrypt(String string) {
        if (!this.sm2config.getEnabled().booleanValue()) {
            return string;
        }
        try {
            return SM2Util.encrypt(this.sm2config.getPublicKey(), string);
        }
        catch (Exception exception) {
            throw new RuntimeException("SM2\u52a0\u5bc6\u5931\u8d25", exception);
        }
    }

    @Override
    public String decrypt(String string) {
        if (!this.sm2config.getEnabled().booleanValue()) {
            return string;
        }
        try {
            return SM2Util.decrypt(this.sm2config.getPrivateKey(), string);
        }
        catch (Exception exception) {
            throw new RuntimeException("SM2\u89e3\u5bc6\u5931\u8d25", exception);
        }
    }

    @Override
    public String encodeForUrl(String string) {
        try {
            return URLEncoder.encode(string, StandardCharsets.UTF_8).replace("+", "%20").replace("%7E", "~");
        }
        catch (Exception exception) {
            throw new IllegalStateException("UTF-8\u7f16\u7801\u4e0d\u652f\u6301", exception);
        }
    }

    @Override
    public String decodeFromUrl(String string) {
        try {
            return URLDecoder.decode(string, StandardCharsets.UTF_8);
        }
        catch (Exception exception) {
            throw new IllegalStateException("UTF-8\u89e3\u7801\u4e0d\u652f\u6301", exception);
        }
    }

    @Override
    public boolean isEnabled() {
        return Boolean.TRUE.equals(this.sm2config.getEnabled());
    }
}

