/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.common.serviceimpl;

import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import plus.hiver.common.base.HiverBaseServiceImpl;
import plus.hiver.common.dao.DepartmentHeaderDao;
import plus.hiver.common.dao.UserDao;
import plus.hiver.common.entity.DepartmentHeader;
import plus.hiver.common.entity.User;
import plus.hiver.common.service.DepartmentHeaderService;
import plus.hiver.common.vo.UserVo;

@Service
@Transactional
public class DepartmentHeaderServiceImpl
extends HiverBaseServiceImpl<DepartmentHeader, Long, DepartmentHeaderDao>
implements DepartmentHeaderService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DepartmentHeaderServiceImpl.class);
    @Resource
    private UserDao userDao;

    public DepartmentHeaderServiceImpl(DepartmentHeaderDao departmentHeaderDao) {
        super(departmentHeaderDao);
    }

    @Override
    public List<UserVo> findHeaderByDepartmentId(Long l, Integer n) {
        ArrayList<UserVo> arrayList = new ArrayList<UserVo>();
        List<DepartmentHeader> list = ((DepartmentHeaderDao)this.dao).findByDepartmentIdAndType(l, n);
        list.forEach(departmentHeader -> {
            User user = (User)this.userDao.getOne(departmentHeader.getUserId());
            if (user != null) {
                arrayList.add(new UserVo().setId(user.getId()).setUsername(user.getUsername()).setNickname(user.getNickname()));
            }
        });
        return arrayList;
    }

    @Override
    public List<DepartmentHeader> findByDepartmentIdIn(List<Long> list) {
        return ((DepartmentHeaderDao)this.dao).findByDepartmentIdIn(list);
    }

    @Override
    public void deleteByDepartmentId(Long l) {
        ((DepartmentHeaderDao)this.dao).deleteByDepartmentId(l);
    }

    @Override
    public void deleteByUserId(Long l) {
        ((DepartmentHeaderDao)this.dao).deleteByUserId(l);
    }

    @Override
    public Boolean isDepartmentHeader(Long l, Long l2) {
        List<DepartmentHeader> list = ((DepartmentHeaderDao)this.dao).findByUserIdAndDepartmentId(l, l2);
        if (list != null && !list.isEmpty()) {
            return true;
        }
        return false;
    }

    @Override
    public List<UserVo> findHeaderByDepartmentId(Long l) {
        ArrayList<UserVo> arrayList = new ArrayList<UserVo>();
        List<DepartmentHeader> list = ((DepartmentHeaderDao)this.dao).findByDepartmentId(l);
        list.forEach(departmentHeader -> {
            User user = (User)this.userDao.getOne(departmentHeader.getUserId());
            if (user != null) {
                arrayList.add(new UserVo().setId(user.getId()).setUsername(user.getUsername()).setNickname(user.getNickname()));
            }
        });
        return arrayList;
    }
}

