/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.common.serviceimpl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.ArrayList;
import java.util.Date;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import plus.hiver.common.base.HiverBaseServiceImpl;
import plus.hiver.common.dao.LogDao;
import plus.hiver.common.entity.Log;
import plus.hiver.common.service.LogService;
import plus.hiver.common.vo.SearchVo;

@Service
@Transactional
public class LogServiceImpl
extends HiverBaseServiceImpl<Log, Long, LogDao>
implements LogService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogServiceImpl.class);

    public LogServiceImpl(LogDao logDao) {
        super(logDao);
    }

    @Override
    public Page<Log> findByConfition(final Integer n, final String string, final SearchVo searchVo, Pageable pageable) {
        return ((LogDao)this.dao).findAll((Specification)new Specification<Log>(){

            @Nullable
            public Predicate toPredicate(Root<Log> root, CriteriaQuery<?> criteriaQuery, CriteriaBuilder criteriaBuilder) {
                Predicate predicate;
                DateTime dateTime;
                Path path = root.get("name");
                Path path2 = root.get("requestUrl");
                Path path3 = root.get("requestType");
                Path path4 = root.get("requestParam");
                Path path5 = root.get("username");
                Path path6 = root.get("ip");
                Path path7 = root.get("ipInfo");
                Path path8 = root.get("device");
                Path path9 = root.get("logType");
                Path path10 = root.get("createTime");
                ArrayList<Predicate> arrayList = new ArrayList<Predicate>();
                if (n != null) {
                    arrayList.add(criteriaBuilder.equal((Expression)path9, (Object)n));
                }
                if (StrUtil.isNotBlank((CharSequence)string)) {
                    dateTime = criteriaBuilder.like((Expression)path2, "%" + string + "%");
                    predicate = criteriaBuilder.like((Expression)path3, "%" + string + "%");
                    Predicate predicate2 = criteriaBuilder.like((Expression)path4, "%" + string + "%");
                    Predicate predicate3 = criteriaBuilder.like((Expression)path5, "%" + string + "%");
                    Predicate predicate4 = criteriaBuilder.like((Expression)path6, "%" + string + "%");
                    Predicate predicate5 = criteriaBuilder.like((Expression)path7, "%" + string + "%");
                    Predicate predicate6 = criteriaBuilder.like((Expression)path, "%" + string + "%");
                    Predicate predicate7 = criteriaBuilder.like((Expression)path8, "%" + string + "%");
                    arrayList.add(criteriaBuilder.or(new Predicate[]{dateTime, predicate, predicate2, predicate3, predicate4, predicate5, predicate6, predicate7}));
                }
                if (StrUtil.isNotBlank((CharSequence)searchVo.getStartDate()) && StrUtil.isNotBlank((CharSequence)searchVo.getEndDate())) {
                    dateTime = DateUtil.parse((CharSequence)searchVo.getStartDate());
                    predicate = DateUtil.parse((CharSequence)searchVo.getEndDate());
                    arrayList.add(criteriaBuilder.between((Expression)path10, (Comparable)dateTime, (Comparable)DateUtil.endOfDay((Date)predicate)));
                }
                dateTime = new Predicate[arrayList.size()];
                criteriaQuery.where(arrayList.toArray((T[])dateTime));
                return null;
            }
        }, pageable);
    }

    @Override
    public void deleteAll() {
        ((LogDao)this.dao).deleteAll();
    }
}

