/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.common.utils;

import cn.hutool.core.util.StrUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.security.SecureRandom;
import javax.imageio.ImageIO;
import plus.hiver.common.exception.HiverException;

public class CreateVerifyCode {
    public static final String STRING = "ABCDEFGHJKMNOPQRSTUVWXYZabcdefghjkmnopqrstuvwxyz1234567890";
    public static final String DIGIT = "1234567890";
    private int width = 160;
    private int height = 40;
    private int codeCount = 4;
    private int lineCount = 20;
    private String code = null;
    private BufferedImage buffImg = null;
    SecureRandom random = new SecureRandom();

    public CreateVerifyCode() {
        this.creatImage();
    }

    public CreateVerifyCode(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.creatImage();
    }

    public CreateVerifyCode(int n, int n2, int n3) {
        this.width = n;
        this.height = n2;
        this.codeCount = n3;
        this.creatImage();
    }

    public CreateVerifyCode(int n, int n2, int n3, int n4) {
        this.width = n;
        this.height = n2;
        this.codeCount = n3;
        this.lineCount = n4;
        this.creatImage();
    }

    public CreateVerifyCode(int n, int n2, int n3, int n4, String string) {
        this.width = n;
        this.height = n2;
        this.codeCount = n3;
        this.lineCount = n4;
        this.creatImage(string);
    }

    private void creatImage() {
        String string;
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = this.width / this.codeCount;
        int n6 = this.height - 5;
        int n7 = this.height - 8;
        this.buffImg = new BufferedImage(this.width, this.height, 1);
        Graphics graphics = this.buffImg.getGraphics();
        graphics.setColor(this.getRandColor(200, 250));
        graphics.fillRect(0, 0, this.width, this.height);
        Font font = new Font("Fixedsys", 1, n6);
        graphics.setFont(font);
        for (int i = 0; i < this.lineCount; ++i) {
            n4 = this.random.nextInt(this.width);
            n3 = this.random.nextInt(this.height);
            n2 = n4 + this.random.nextInt(this.width);
            n = n3 + this.random.nextInt(this.height);
            graphics.setColor(this.getRandColor(1, 255));
            graphics.drawLine(n4, n3, n2, n);
        }
        float f = 0.01f;
        n4 = (int)(f * (float)this.width * (float)this.height);
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = this.random.nextInt(this.width);
            n = this.random.nextInt(this.height);
            this.buffImg.setRGB(n2, n, this.random.nextInt(255));
        }
        this.code = string = this.randomStr(this.codeCount);
        for (n2 = 0; n2 < this.codeCount; ++n2) {
            String string2 = string.substring(n2, n2 + 1);
            graphics.setColor(this.getRandColor(1, 255));
            graphics.drawString(string2, n2 * n5 + 3, n7);
        }
    }

    private void creatImage(String string) {
        int n;
        int n2;
        int n3;
        int n4;
        if (StrUtil.isBlank((CharSequence)string)) {
            throw new HiverException("\u9a8c\u8bc1\u7801\u4e3a\u7a7a\u6216\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6");
        }
        int n5 = this.width / this.codeCount;
        int n6 = this.height - 5;
        int n7 = this.height - 8;
        this.buffImg = new BufferedImage(this.width, this.height, 1);
        Graphics graphics = this.buffImg.getGraphics();
        graphics.setColor(this.getRandColor(200, 250));
        graphics.fillRect(0, 0, this.width, this.height);
        Font font = new Font("Fixedsys", 1, n6);
        graphics.setFont(font);
        for (int i = 0; i < this.lineCount; ++i) {
            n4 = this.random.nextInt(this.width);
            n3 = this.random.nextInt(this.height);
            n2 = n4 + this.random.nextInt(this.width);
            n = n3 + this.random.nextInt(this.height);
            graphics.setColor(this.getRandColor(1, 255));
            graphics.drawLine(n4, n3, n2, n);
        }
        float f = 0.01f;
        n4 = (int)(f * (float)this.width * (float)this.height);
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = this.random.nextInt(this.width);
            n = this.random.nextInt(this.height);
            this.buffImg.setRGB(n2, n, this.random.nextInt(255));
        }
        this.code = string;
        for (n3 = 0; n3 < string.length(); ++n3) {
            String string2 = string.substring(n3, n3 + 1);
            graphics.setColor(this.getRandColor(1, 255));
            graphics.drawString(string2, n3 * n5 + 3, n7);
        }
    }

    public String randomStr(int n) {
        Object object = "";
        int n2 = STRING.length() - 1;
        for (int i = 0; i < n; ++i) {
            double d = this.random.nextDouble() * (double)n2;
            object = (String)object + STRING.charAt((int)d);
        }
        return object;
    }

    public String randomDigit(int n) {
        Object object = "";
        int n2 = DIGIT.length() - 1;
        for (int i = 0; i < n; ++i) {
            double d = this.random.nextDouble() * (double)n2;
            object = (String)object + DIGIT.charAt((int)d);
        }
        return object;
    }

    private Color getRandColor(int n, int n2) {
        if (n > 255) {
            n = 255;
        }
        if (n2 > 255) {
            n2 = 255;
        }
        int n3 = n + this.random.nextInt(n2 - n);
        int n4 = n + this.random.nextInt(n2 - n);
        int n5 = n + this.random.nextInt(n2 - n);
        return new Color(n3, n4, n5);
    }

    private Font getFont(int n) {
        Font[] fontArray = new Font[]{new Font("Ravie", 0, n), new Font("Antique Olive Compact", 0, n), new Font("Fixedsys", 0, n), new Font("Wide Latin", 0, n), new Font("Gill Sans Ultra Bold", 0, n)};
        return fontArray[this.random.nextInt(5)];
    }

    private void shear(Graphics graphics, int n, int n2, Color color) {
        this.shearX(graphics, n, n2, color);
        this.shearY(graphics, n, n2, color);
    }

    private void shearX(Graphics graphics, int n, int n2, Color color) {
        int n3 = this.random.nextInt(2);
        boolean bl = true;
        boolean bl2 = true;
        int n4 = this.random.nextInt(2);
        for (int i = 0; i < n2; ++i) {
            double d = (double)(n3 >> 1) * Math.sin((double)i / (double)n3 + Math.PI * 2 * (double)n4 / (double)bl2);
            graphics.copyArea(0, i, n, 1, (int)d, 0);
            if (!bl) continue;
            graphics.setColor(color);
            graphics.drawLine((int)d, i, 0, i);
            graphics.drawLine((int)d + n, i, n, i);
        }
    }

    private void shearY(Graphics graphics, int n, int n2, Color color) {
        int n3 = this.random.nextInt(40) + 10;
        boolean bl = true;
        int n4 = 20;
        int n5 = 7;
        for (int i = 0; i < n; ++i) {
            double d = (double)(n3 >> 1) * Math.sin((double)i / (double)n3 + Math.PI * 2 * (double)n5 / (double)n4);
            graphics.copyArea(i, 0, 1, n2, 0, (int)d);
            if (!bl) continue;
            graphics.setColor(color);
            graphics.drawLine(i, (int)d, i, 0);
            graphics.drawLine(i, (int)d + n2, i, n2);
        }
    }

    public void write(OutputStream outputStream) throws IOException {
        ImageIO.write((RenderedImage)this.buffImg, "png", outputStream);
        outputStream.close();
    }

    public BufferedImage getBuffImg() {
        return this.buffImg;
    }

    public String getCode() {
        return this.code.toLowerCase();
    }
}

