/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.common.utils;

import cn.hutool.core.util.StrUtil;
import com.google.gson.Gson;
import jakarta.annotation.Resource;
import jakarta.mail.internet.MimeMessage;
import java.io.File;
import java.util.Properties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import plus.hiver.common.entity.Setting;
import plus.hiver.common.exception.HiverException;
import plus.hiver.common.service.SettingService;
import plus.hiver.common.vo.EmailSetting;

@Component
public class EmailUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EmailUtil.class);
    @Resource
    private TemplateEngine templateEngine;
    @Resource
    private SettingService settingService;

    public EmailSetting getEmailSetting() {
        Setting setting = this.settingService.findByKey("EMAIL_SETTING");
        if (StrUtil.isBlank((CharSequence)setting.getValue())) {
            throw new HiverException("\u60a8\u8fd8\u672a\u914d\u7f6e\u90ae\u4ef6\u53d1\u9001\u76f8\u5173\u914d\u7f6e");
        }
        return (EmailSetting)new Gson().fromJson(setting.getValue(), EmailSetting.class);
    }

    @Async
    public void sendSimpleMail(String string, String string2, String string3, boolean bl, String ... stringArray) {
        EmailSetting emailSetting = this.getEmailSetting();
        JavaMailSenderImpl javaMailSenderImpl = new JavaMailSenderImpl();
        javaMailSenderImpl.setHost(emailSetting.getHost());
        javaMailSenderImpl.setUsername(emailSetting.getUsername());
        javaMailSenderImpl.setPassword(emailSetting.getPassword());
        Properties properties = new Properties();
        properties.put("mail.smtp.auth", "true");
        properties.put("mail.smtp.timeout", "20000");
        properties.setProperty("mail.smtp.port", "465");
        properties.setProperty("mail.smtp.socketFactory.port", "465");
        properties.put("mail.smtp.ssl.enable", "true");
        javaMailSenderImpl.setJavaMailProperties(properties);
        MimeMessage mimeMessage = javaMailSenderImpl.createMimeMessage();
        MimeMessageHelper mimeMessageHelper = null;
        try {
            mimeMessageHelper = new MimeMessageHelper(mimeMessage, true, "utf-8");
            mimeMessageHelper.setFrom(emailSetting.getUsername());
            mimeMessageHelper.setTo(string);
            mimeMessageHelper.setSubject(string2);
            mimeMessageHelper.setText(string3, bl);
            for (String string4 : stringArray) {
                FileSystemResource fileSystemResource = new FileSystemResource(new File(string4));
                String string5 = fileSystemResource.getFilename();
                mimeMessageHelper.addAttachment(string5, (InputStreamSource)fileSystemResource);
            }
            javaMailSenderImpl.send(mimeMessage);
            log.info("\u90ae\u4ef6\u5df2\u53d1\u9001\u81f3\uff1a{}", (Object)string);
        }
        catch (Exception exception) {
            log.info("\u90ae\u4ef6\uff1a{}\u5931\u8d25", (Object)string);
            throw new HiverException("\u53d1\u9001\u90ae\u4ef6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u90ae\u4ef6\u914d\u7f6e");
        }
    }

    @Async
    public void sendInlineResourceMail(String string, String string2, String string3, String string4, String string5, boolean bl, String ... stringArray) {
        EmailSetting emailSetting = this.getEmailSetting();
        JavaMailSenderImpl javaMailSenderImpl = new JavaMailSenderImpl();
        javaMailSenderImpl.setHost(emailSetting.getHost());
        javaMailSenderImpl.setUsername(emailSetting.getUsername());
        javaMailSenderImpl.setPassword(emailSetting.getPassword());
        Properties properties = new Properties();
        properties.put("mail.smtp.auth", "true");
        properties.put("mail.smtp.timeout", "20000");
        properties.setProperty("mail.smtp.port", "465");
        properties.setProperty("mail.smtp.socketFactory.port", "465");
        properties.put("mail.smtp.ssl.enable", "true");
        javaMailSenderImpl.setJavaMailProperties(properties);
        MimeMessage mimeMessage = javaMailSenderImpl.createMimeMessage();
        MimeMessageHelper mimeMessageHelper = null;
        try {
            mimeMessageHelper = new MimeMessageHelper(mimeMessage, true, "utf-8");
            mimeMessageHelper.setFrom(emailSetting.getUsername());
            mimeMessageHelper.setTo(string);
            mimeMessageHelper.setSubject(string2);
            mimeMessageHelper.setText(string3, bl);
            FileSystemResource fileSystemResource = new FileSystemResource(new File(string4));
            mimeMessageHelper.addInline(string5, (org.springframework.core.io.Resource)fileSystemResource);
            for (String string6 : stringArray) {
                FileSystemResource fileSystemResource2 = new FileSystemResource(new File(string6));
                String string7 = fileSystemResource2.getFilename();
                mimeMessageHelper.addAttachment(string7, (InputStreamSource)fileSystemResource2);
            }
            javaMailSenderImpl.send(mimeMessage);
            log.info("\u90ae\u4ef6\u5df2\u53d1\u9001\u81f3\uff1a{}", (Object)string);
        }
        catch (Exception exception) {
            log.info("\u90ae\u4ef6\uff1a{}\u5931\u8d25", (Object)string);
            throw new HiverException("\u53d1\u9001\u90ae\u4ef6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u90ae\u4ef6\u914d\u7f6e");
        }
    }

    @Async
    public void sendTemplateMail(String string, String string2, String string3, Context context, String ... stringArray) {
        EmailSetting emailSetting = this.getEmailSetting();
        JavaMailSenderImpl javaMailSenderImpl = new JavaMailSenderImpl();
        javaMailSenderImpl.setHost(emailSetting.getHost());
        javaMailSenderImpl.setUsername(emailSetting.getUsername());
        javaMailSenderImpl.setPassword(emailSetting.getPassword());
        Properties properties = new Properties();
        properties.put("mail.smtp.auth", "true");
        properties.put("mail.smtp.timeout", "20000");
        properties.setProperty("mail.smtp.port", "465");
        properties.setProperty("mail.smtp.socketFactory.port", "465");
        properties.put("mail.smtp.ssl.enable", "true");
        javaMailSenderImpl.setJavaMailProperties(properties);
        MimeMessage mimeMessage = javaMailSenderImpl.createMimeMessage();
        MimeMessageHelper mimeMessageHelper = null;
        try {
            mimeMessageHelper = new MimeMessageHelper(mimeMessage, true, "utf-8");
            mimeMessageHelper.setFrom(emailSetting.getUsername());
            mimeMessageHelper.setTo(string);
            mimeMessageHelper.setSubject(string2);
            for (String string4 : stringArray) {
                FileSystemResource fileSystemResource = new FileSystemResource(new File(string4));
                String string5 = fileSystemResource.getFilename();
                mimeMessageHelper.addAttachment(string5, (InputStreamSource)fileSystemResource);
            }
            String exception = this.templateEngine.process(string3, (IContext)context);
            mimeMessageHelper.setText(exception, true);
            javaMailSenderImpl.send(mimeMessage);
            log.info("\u90ae\u4ef6\u5df2\u53d1\u9001\u81f3\uff1a{}", (Object)string);
        }
        catch (Exception exception) {
            log.info("\u90ae\u4ef6\uff1a{}\u5931\u8d25", (Object)string);
            throw new HiverException("\u53d1\u9001\u90ae\u4ef6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u90ae\u4ef6\u914d\u7f6e");
        }
    }
}

