/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.common.utils.collection;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class CollectionUtils {
    public static String[] copy(String[] stringArray) {
        if (CollectionUtils.isEmpty(stringArray)) {
            return null;
        }
        int n = stringArray.length;
        String[] stringArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = stringArray[i];
        }
        return stringArray2;
    }

    public static String concat(String[] stringArray, String string) {
        if (CollectionUtils.isEmpty(stringArray)) {
            return null;
        }
        String string2 = "";
        for (int i = 0; i < stringArray.length; ++i) {
            string2 = string2.concat(stringArray[i]);
            if (i == stringArray.length - 1) continue;
            string2 = string2.concat(string);
        }
        return string2;
    }

    public static boolean isEmpty(String[] stringArray) {
        if (null == stringArray) {
            return true;
        }
        return 0 == stringArray.length;
    }

    public static boolean containsAny(Object object, Object ... objectArray) {
        return Arrays.asList(objectArray).contains(object);
    }

    public static boolean isAnyEmpty(Collection<?> ... collectionArray) {
        return Arrays.stream(collectionArray).anyMatch(CollUtil::isEmpty);
    }

    public static <T> List<T> filterList(Collection<T> collection, Predicate<T> predicate) {
        if (CollUtil.isEmpty(collection)) {
            return new ArrayList();
        }
        return collection.stream().filter(predicate).collect(Collectors.toList());
    }

    public static <T, R> List<T> distinct(Collection<T> collection, Function<T, R> function) {
        if (CollUtil.isEmpty(collection)) {
            return new ArrayList();
        }
        return CollectionUtils.distinct(collection, function, (object, object2) -> object);
    }

    public static <T, R> List<T> distinct(Collection<T> collection, Function<T, R> function, BinaryOperator<T> binaryOperator) {
        if (CollUtil.isEmpty(collection)) {
            return new ArrayList();
        }
        return new ArrayList(CollectionUtils.convertMap(collection, function, Function.identity(), binaryOperator).values());
    }

    public static <T, U> List<U> convertList(Collection<T> collection, Function<T, U> function) {
        if (CollUtil.isEmpty(collection)) {
            return new ArrayList();
        }
        return collection.stream().map(function).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static <T, U> List<U> convertList(Collection<T> collection, Function<T, U> function, Predicate<T> predicate) {
        if (CollUtil.isEmpty(collection)) {
            return new ArrayList();
        }
        return collection.stream().filter(predicate).map(function).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static <T, U> Set<U> convertSet(Collection<T> collection, Function<T, U> function) {
        if (CollUtil.isEmpty(collection)) {
            return new HashSet();
        }
        return collection.stream().map(function).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static <T, U> Set<U> convertSet(Collection<T> collection, Function<T, U> function, Predicate<T> predicate) {
        if (CollUtil.isEmpty(collection)) {
            return new HashSet();
        }
        return collection.stream().filter(predicate).map(function).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static <T, K> Map<K, T> convertMap(Collection<T> collection, Function<T, K> function) {
        if (CollUtil.isEmpty(collection)) {
            return new HashMap();
        }
        return CollectionUtils.convertMap(collection, function, Function.identity());
    }

    public static <T, K> Map<K, T> convertMap(Collection<T> collection, Function<T, K> function, Supplier<? extends Map<K, T>> supplier) {
        if (CollUtil.isEmpty(collection)) {
            return supplier.get();
        }
        return CollectionUtils.convertMap(collection, function, Function.identity(), supplier);
    }

    public static <T, K, V> Map<K, V> convertMap(Collection<T> collection, Function<T, K> function, Function<T, V> function2) {
        if (CollUtil.isEmpty(collection)) {
            return new HashMap();
        }
        return CollectionUtils.convertMap(collection, function, function2, (object, object2) -> object);
    }

    public static <T, K, V> Map<K, V> convertMap(Collection<T> collection, Function<T, K> function, Function<T, V> function2, BinaryOperator<V> binaryOperator) {
        if (CollUtil.isEmpty(collection)) {
            return new HashMap();
        }
        return CollectionUtils.convertMap(collection, function, function2, binaryOperator, HashMap::new);
    }

    public static <T, K, V> Map<K, V> convertMap(Collection<T> collection, Function<T, K> function, Function<T, V> function2, Supplier<? extends Map<K, V>> supplier) {
        if (CollUtil.isEmpty(collection)) {
            return supplier.get();
        }
        return CollectionUtils.convertMap(collection, function, function2, (object, object2) -> object, supplier);
    }

    public static <T, K, V> Map<K, V> convertMap(Collection<T> collection, Function<T, K> function, Function<T, V> function2, BinaryOperator<V> binaryOperator, Supplier<? extends Map<K, V>> supplier) {
        if (CollUtil.isEmpty(collection)) {
            return new HashMap();
        }
        return collection.stream().collect(Collectors.toMap(function, function2, binaryOperator, supplier));
    }

    public static <T, K> Map<K, List<T>> convertMultiMap(Collection<T> collection, Function<T, K> function) {
        if (CollUtil.isEmpty(collection)) {
            return new HashMap();
        }
        return collection.stream().collect(Collectors.groupingBy(function, Collectors.mapping(object -> object, Collectors.toList())));
    }

    public static <T, K, V> Map<K, List<V>> convertMultiMap(Collection<T> collection, Function<T, K> function, Function<T, V> function2) {
        if (CollUtil.isEmpty(collection)) {
            return new HashMap();
        }
        return collection.stream().collect(Collectors.groupingBy(function, Collectors.mapping(function2, Collectors.toList())));
    }

    public static <T, K, V> Map<K, Set<V>> convertMultiMap2(Collection<T> collection, Function<T, K> function, Function<T, V> function2) {
        if (CollUtil.isEmpty(collection)) {
            return new HashMap();
        }
        return collection.stream().collect(Collectors.groupingBy(function, Collectors.mapping(function2, Collectors.toSet())));
    }

    public static boolean containsAny(Collection<?> collection, Collection<?> collection2) {
        return org.springframework.util.CollectionUtils.containsAny(collection, collection2);
    }

    public static <T> T getFirst(List<T> list) {
        return !CollectionUtil.isEmpty(list) ? (T)list.get(0) : null;
    }

    public static <T> T findFirst(List<T> list, Predicate<T> predicate) {
        if (CollUtil.isEmpty(list)) {
            return null;
        }
        return list.stream().filter(predicate).findFirst().orElse(null);
    }

    public static <T, V extends Comparable<? super V>> V getMaxValue(List<T> list, Function<T, V> function) {
        if (CollUtil.isEmpty(list)) {
            return null;
        }
        assert (list.size() > 0);
        Object e = list.stream().max(Comparator.comparing(function)).get();
        return (V)((Comparable)function.apply(e));
    }

    public static <T, V extends Comparable<? super V>> V getMinValue(List<T> list, Function<T, V> function) {
        if (CollUtil.isEmpty(list)) {
            return null;
        }
        assert (list.size() > 0);
        Object e = list.stream().min(Comparator.comparing(function)).get();
        return (V)((Comparable)function.apply(e));
    }

    public static <T, V extends Comparable<? super V>> V getSumValue(List<T> list, Function<T, V> function, BinaryOperator<V> binaryOperator) {
        if (CollUtil.isEmpty(list)) {
            return null;
        }
        assert (list.size() > 0);
        return (V)((Comparable)list.stream().map(function).reduce(binaryOperator).get());
    }

    public static <T> void addIfNotNull(Collection<T> collection, T t) {
        if (t == null) {
            return;
        }
        collection.add(t);
    }

    public static <T> Collection<T> singleton(T t) {
        return t == null ? Collections.emptyList() : Collections.singleton(t);
    }
}

