/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.config.bean;

import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import plus.hiver.common.aop.DecryptAspect;
import plus.hiver.common.config.sm2.Sm2Service;

/**
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Configuration
public class AopConfig {
    @Bean
    public DecryptAspect decryptAspect(Sm2Service sm2Service) {
        return new DecryptAspect(sm2Service);
    }

    @Bean
    public TomcatServletWebServerFactory tomcatFactory() {
        TomcatServletWebServerFactory factory = new TomcatServletWebServerFactory();
        factory.addConnectorCustomizers(connector -> {
            connector.setProperty("relaxedPathChars", "<>[\\]^`{|}");
            connector.setProperty("relaxedQueryChars", "<>[\\]^`{|}");
        });
        return factory;
    }
}
