/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.constant;

/**
 * 消息常量
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
public interface MessageConstant {
    /**
     * 消息发送范围 所有
     */
    Integer MESSAGE_RANGE_ALL = 0;

    /**
     * 消息发送范围指定用户
     */
    Integer MESSAGE_RANGE_USER = 1;

    /**
     * 未读
     */
    Integer MESSAGE_STATUS_UNREAD = 0;

    /**
     * 已读
     */
    Integer MESSAGE_STATUS_READ = 1;

    /**
     * 短信发送范围 所有
     */
    Integer SMS_RANGE_ALL = 0;

    /**
     * 短信发送范围 已注册
     */
    Integer SMS_RANGE_REG = 1;

    /**
     * 短信发送范围 未注册
     */
    Integer SMS_RANGE_UNREG = 2;
}
