/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.dao;

import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import plus.hiver.common.base.HiverBaseDao;
import plus.hiver.common.entity.UserRole;

import java.util.List;

/**
 * 用户角色数据处理层
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Repository
public interface UserRoleDao extends HiverBaseDao<UserRole, Long> {
    /**
     * 通过roleId查找
     */
    List<UserRole> findByRoleId(Long roleId);

    /**
     * 删除用户角色
     */
    @Modifying
    @Query("delete from UserRole u where u.userId = ?1")
    void deleteByUserId(Long userId);
}
