/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import plus.hiver.common.base.HiverBaseEntity;
import plus.hiver.common.constant.HiverConstant;

import java.util.List;

/**
 * 角色实体类
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Data
@Entity
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Table(name = "t_role")
@TableName("t_role")
@Tag(name = "角色")
public class Role extends HiverBaseEntity {
    private static final long serialVersionUID = 1L;

    @Schema(description = "角色名 以ROLE_开头")
    private String name;

    @Schema(description = "是否为注册默认角色")
    private Boolean defaultRole;

    @Schema(description = "数据权限类型 0全部默认 1自定义 2本部门及以下 3本部门 4仅本人")
    private Integer dataType = HiverConstant.DATA_TYPE_ALL;

    @Schema(description = "备注")
    private String description;

    @Transient
    @TableField(exist = false)
    @Schema(description = "拥有权限")
    private List<RolePermission> permissions;

    @Transient
    @TableField(exist = false)
    @Schema(description = "拥有数据权限")
    private List<RoleDepartment> departments;
}
