/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.serviceimpl.mybatis;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.springframework.stereotype.Service;
import plus.hiver.common.config.mybatisplus.service.BaseServiceImpl;
import plus.hiver.common.dao.mapper.UserRoleMapper;
import plus.hiver.common.entity.Role;
import plus.hiver.common.entity.UserRole;
import plus.hiver.common.service.mybatis.IUserRoleService;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 用户角色接口实现类
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Service
public class IUserRoleServiceImpl extends BaseServiceImpl<UserRoleMapper, UserRole> implements IUserRoleService {
    @Override
    public List<Role> findByUserId(Long userId) {
        return baseMapper.findByUserId(userId);
    }

    @Override
    public List<Long> findDepIdsByUserId(Long userId) {
        return baseMapper.findDepIdsByUserId(userId);
    }

    @Override
    public List<Long> listbyRoleIds(List<Long> roleIds) {
        LambdaQueryWrapper<UserRole> lambdaQueryWrapper = Wrappers.<UserRole>lambdaQuery().in(UserRole::getRoleId, roleIds);
        List<UserRole> list = super.list(lambdaQueryWrapper);
        return list.stream().map(UserRole::getUserId).collect(Collectors.toList());
    }
}
