/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.serviceimpl;

import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import plus.hiver.common.base.HiverBaseServiceImpl;
import plus.hiver.common.dao.RoleDepartmentDao;
import plus.hiver.common.entity.RoleDepartment;
import plus.hiver.common.service.RoleDepartmentService;

import java.util.List;

/**
 * 角色部门接口实现
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Slf4j
@Service
@Transactional
public class RoleDepartmentServiceImpl extends HiverBaseServiceImpl<RoleDepartment, Long, RoleDepartmentDao> implements RoleDepartmentService {
    public RoleDepartmentServiceImpl(RoleDepartmentDao dao) {
        super(dao);
    }

    @Override
    public List<RoleDepartment> findByRoleId(Long roleId) {
        return dao.findByRoleId(roleId);
    }

    @Override
    public void deleteByRoleId(Long roleId) {
        dao.deleteByRoleId(roleId);
    }

    @Override
    public void deleteByDepartmentId(Long departmentId) {
        dao.deleteByDepartmentId(departmentId);
    }
}
