/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;

/**
 * 邮箱配置
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Data
public class EmailSetting implements Serializable {
    @Schema(description = "邮箱服务器")
    private String host;

    @Schema(description = "发送者邮箱账号")
    private String username;

    @Schema(description = "邮箱授权码")
    private String password;

    @Schema(description = "是否改变secrectKey")
    private Boolean changed;
}
