/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.common.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;

/**
 * 单点登录配置
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Data
public class OtherSetting implements Serializable {
    @Schema(description = "域名")
    private String domain;

    @Schema(description = "单点登录域名")
    private String ssoDomain;

    @Schema(description = "IP黑名单")
    private String blacklist;
}
