/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.common.aop;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import lombok.Generated;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;
import plus.hiver.common.annotation.Decrypt;
import plus.hiver.common.config.sm2.Sm2Service;
import plus.hiver.common.exception.HiverException;

@Aspect
@Component
public class DecryptAspect {
    private final Sm2Service sm2Service;

    @Around(value="execution(* *(.., @plus.hiver.common.annotation.Decrypt (*), ..)) && (@within(org.springframework.stereotype.Controller) || @within(org.springframework.web.bind.annotation.RestController))")
    public Object around(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        if (!this.sm2Service.isEnabled()) {
            return proceedingJoinPoint.proceed();
        }
        MethodSignature methodSignature = (MethodSignature)proceedingJoinPoint.getSignature();
        Method method = methodSignature.getMethod();
        Parameter[] parameterArray = method.getParameters();
        Object[] objectArray = proceedingJoinPoint.getArgs();
        for (int i = 0; i < parameterArray.length; ++i) {
            if (!this.shouldDecrypt(parameterArray[i])) continue;
            objectArray[i] = this.processDecryption(objectArray[i], parameterArray[i]);
        }
        return proceedingJoinPoint.proceed(objectArray);
    }

    private boolean shouldDecrypt(Parameter parameter) {
        return parameter.isAnnotationPresent(Decrypt.class);
    }

    private Object processDecryption(Object object, Parameter parameter) {
        if (!(object instanceof String)) {
            return object;
        }
        try {
            String string = (String)object;
            String string2 = this.sm2Service.decodeFromUrl(this.base64Decode(string));
            return this.sm2Service.decrypt(string2);
        }
        catch (Exception exception) {
            throw new HiverException("\u53c2\u6570\u89e3\u5bc6\u5931\u8d25: " + parameter.getName(), exception);
        }
    }

    private String base64Decode(String string) {
        return new String(Base64.getDecoder().decode(string), StandardCharsets.UTF_8);
    }

    @Generated
    public DecryptAspect(Sm2Service sm2Service) {
        this.sm2Service = sm2Service;
    }
}

