/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.common.aop;

import cn.hutool.http.useragent.UserAgent;
import cn.hutool.http.useragent.UserAgentUtil;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.NamedThreadLocal;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;
import plus.hiver.common.annotation.SystemLog;
import plus.hiver.common.entity.Log;
import plus.hiver.common.service.LogService;
import plus.hiver.common.utils.IpInfoUtil;
import plus.hiver.common.utils.ObjectUtil;
import plus.hiver.common.utils.ThreadPoolUtil;
import plus.hiver.common.vo.TokenUser;

@Aspect
@Component
public class SystemLogAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SystemLogAspect.class);
    private static final ThreadLocal<StopWatch> THREAD_LOCAL_TIMER = new NamedThreadLocal("ThreadLocalStopWatch");
    @Autowired
    private LogService logService;
    @Autowired(required=false)
    private HttpServletRequest request;
    @Autowired
    private IpInfoUtil ipInfoUtil;

    @Pointcut(value="@annotation(plus.hiver.common.annotation.SystemLog)")
    public void controllerAspect() {
    }

    @Before(value="controllerAspect()")
    public void doBefore(JoinPoint joinPoint) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        THREAD_LOCAL_TIMER.set(stopWatch);
    }

    @AfterReturning(value="controllerAspect()")
    public void after(JoinPoint joinPoint) {
        try {
            String string = "";
            Object object = "";
            String string2 = "PC\u7aef";
            String string3 = SystemLogAspect.getControllerMethodInfo(joinPoint).get("description").toString();
            int n = (Integer)SystemLogAspect.getControllerMethodInfo(joinPoint).get("type");
            Map map = this.request.getParameterMap();
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            if (authentication == null || !authentication.isAuthenticated() || authentication.getName() == null || authentication instanceof AnonymousAuthenticationToken) {
                return;
            }
            TokenUser tokenUser = (TokenUser)authentication.getPrincipal();
            string = tokenUser != null ? tokenUser.getUsername() : "";
            UserAgent userAgent = UserAgentUtil.parse((String)this.request.getHeader("user-agent"));
            if (userAgent != null) {
                if (userAgent.isMobile()) {
                    string2 = "\u79fb\u52a8\u7aef";
                }
                object = userAgent.getBrowser().toString() + " " + userAgent.getVersion() + " | " + userAgent.getPlatform().toString() + " " + userAgent.getOs().toString() + " | " + string2;
            }
            Log log = new Log();
            log.setUsername(string);
            log.setName(string3);
            log.setLogType(n);
            log.setRequestUrl(this.request.getRequestURI());
            log.setRequestType(this.request.getMethod());
            log.setMapToParams(map);
            this.ipInfoUtil.getInfo(this.request, ObjectUtil.mapToStringAll(this.request.getParameterMap()));
            log.setIp(IpInfoUtil.getIpAddr(this.request));
            log.setIpInfo(this.ipInfoUtil.getIpCity(this.request));
            log.setDevice((String)object);
            StopWatch stopWatch = THREAD_LOCAL_TIMER.get();
            if (stopWatch != null && stopWatch.isRunning()) {
                stopWatch.stop();
                log.setCostTime((int)stopWatch.getTotalTimeMillis());
            }
            ThreadPoolUtil.getPool().execute(new SaveSystemLogThread(log, this.logService));
            THREAD_LOCAL_TIMER.remove();
        }
        catch (Exception exception) {
            log.error("AOP\u540e\u7f6e\u901a\u77e5\u5f02\u5e38", (Throwable)exception);
        }
    }

    public static Map<String, Object> getControllerMethodInfo(JoinPoint joinPoint) throws ClassNotFoundException {
        ConcurrentHashMap<String, Object> concurrentHashMap = new ConcurrentHashMap<String, Object>(16);
        String string = joinPoint.getTarget().getClass().getName();
        String string2 = joinPoint.getSignature().getName();
        Object[] objectArray = joinPoint.getArgs();
        Class<?> clazz = Class.forName(string);
        Method[] methodArray = clazz.getMethods();
        String string3 = "";
        Integer n = null;
        for (Method method : methodArray) {
            SystemLog systemLog;
            Class<?>[] classArray;
            if (!method.getName().equals(string2) || (classArray = method.getParameterTypes()).length != objectArray.length || (systemLog = method.getAnnotation(SystemLog.class)) == null) continue;
            string3 = systemLog.description();
            n = systemLog.type().ordinal();
            concurrentHashMap.put("description", string3);
            concurrentHashMap.put("type", n);
            break;
        }
        return concurrentHashMap;
    }

    private static class SaveSystemLogThread
    implements Runnable {
        private final Log logger;
        private final LogService logService;

        public SaveSystemLogThread(Log log, LogService logService) {
            this.logger = log;
            this.logService = logService;
        }

        @Override
        public void run() {
            try {
                this.logService.save(this.logger);
            }
            catch (Exception exception) {
                log.error("\u4fdd\u5b58\u65e5\u5fd7\u5f02\u5e38", (Throwable)exception);
            }
        }
    }
}

