/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.common.base;

import io.swagger.v3.oas.annotations.Operation;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import plus.hiver.common.api.Result;
import plus.hiver.common.base.HiverBaseEntity;
import plus.hiver.common.base.HiverBaseService;
import plus.hiver.common.utils.PageUtil;
import plus.hiver.common.utils.ResultUtil;
import plus.hiver.common.vo.PageVo;

public abstract class HiverBaseController<T extends HiverBaseEntity, ID extends Long> {
    public abstract HiverBaseService<T, ID> getService();

    @GetMapping(value={"/get/{id}"})
    @ResponseBody
    @Operation(summary="\u901a\u8fc7id\u83b7\u53d6")
    public Result<T> get(@PathVariable ID ID) {
        T t = this.getService().get(ID);
        return new ResultUtil<T>().setData(t);
    }

    @GetMapping(value={"/getAll"})
    @ResponseBody
    @Operation(summary="\u83b7\u53d6\u5168\u90e8\u6570\u636e")
    public Result<List<T>> getAll() {
        List<T> list = this.getService().getAll();
        return new ResultUtil<List<T>>().setData(list);
    }

    @GetMapping(value={"/getByPage"})
    @ResponseBody
    @Operation(summary="\u5206\u9875\u83b7\u53d6")
    public Result<Page<T>> getByPage(PageVo pageVo) {
        Page<T> page = this.getService().findAll(PageUtil.initPage(pageVo));
        return new ResultUtil<Page<T>>().setData(page);
    }

    @PostMapping(value={"/save"})
    @ResponseBody
    @Operation(summary="\u4fdd\u5b58\u6570\u636e")
    public Result<T> save(T t) {
        T t2 = this.getService().save(t);
        return new ResultUtil<T>().setData(t2);
    }

    @PutMapping(value={"/update"})
    @ResponseBody
    @Operation(summary="\u66f4\u65b0\u6570\u636e")
    public Result<T> update(T t) {
        T t2 = this.getService().update(t);
        return new ResultUtil<T>().setData(t2);
    }

    @PostMapping(value={"/delByIds"})
    @ResponseBody
    @Operation(summary="\u6279\u91cf\u901a\u8fc7id\u5220\u9664")
    public Result<Object> delByIds(ID[] IDArray) {
        for (ID ID : IDArray) {
            this.getService().delete(ID);
        }
        return ResultUtil.success("\u6279\u91cf\u901a\u8fc7id\u5220\u9664\u6570\u636e\u6210\u529f");
    }
}

