/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.common.base;

import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import plus.hiver.common.base.HiverBaseDao;
import plus.hiver.common.base.HiverBaseEntity;
import plus.hiver.common.base.HiverBaseService;

public abstract class HiverBaseServiceImpl<T extends HiverBaseEntity, ID extends Long, R extends HiverBaseDao<T, ID>>
implements HiverBaseService<T, ID> {
    protected final R dao;

    protected HiverBaseServiceImpl(R r) {
        this.dao = r;
    }

    @Override
    public T get(ID ID) {
        return this.findById(ID);
    }

    @Override
    public T findById(ID ID) {
        return (T)((HiverBaseEntity)this.dao.findById(ID).orElse(null));
    }

    @Override
    public List<T> getAll() {
        return this.dao.findAll();
    }

    @Override
    public Long getTotalCount() {
        return this.dao.findAll().size();
    }

    @Override
    public T save(T t) {
        return (T)((HiverBaseEntity)this.dao.save(t));
    }

    @Override
    public T update(T t) {
        return (T)((HiverBaseEntity)this.dao.saveAndFlush(t));
    }

    @Override
    public List<T> saveOrUpdateAll(List<T> list) {
        return this.dao.saveAll(list);
    }

    @Override
    public void delete(T t) {
        this.dao.delete(t);
    }

    @Override
    public void delete(ID ID) {
        this.dao.deleteById(ID);
    }

    @Override
    public void deleteAllById(List<ID> list) {
        this.dao.deleteAllById(list);
    }

    @Override
    public void delete(List<T> list) {
        this.dao.deleteAll(list);
    }

    @Override
    public void flush() {
        this.dao.flush();
    }

    @Override
    public List<T> findAll(Specification<T> specification) {
        return this.dao.findAll();
    }

    @Override
    public Page<T> findAll(Pageable pageable) {
        return this.dao.findAll(pageable);
    }

    @Override
    public Page<T> findAll(Specification<T> specification, Pageable pageable) {
        return this.dao.findAll(specification, pageable);
    }

    @Override
    public long count(Specification<T> specification) {
        return this.dao.findAll(specification).size();
    }
}

