/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.common.config.jpa.auditor;

import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.domain.AuditorAware;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import plus.hiver.common.vo.TokenUser;

@Configuration
public class UserIdAuditor
implements AuditorAware<Long> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserIdAuditor.class);

    public Optional<Long> getCurrentAuditor() {
        try {
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            if (authentication != null && authentication.isAuthenticated() && !(authentication instanceof AnonymousAuthenticationToken)) {
                TokenUser tokenUser = (TokenUser)authentication.getPrincipal();
                Long l = null;
                if (tokenUser != null) {
                    l = tokenUser.getUserId();
                    boolean bl = this.isCreateOperation();
                    if (bl && l != null) {
                        return Optional.of(l);
                    }
                }
            }
            return Optional.empty();
        }
        catch (Exception exception) {
            log.warn("Failed to get current user auditor: {}", (Object)exception.getMessage());
            return Optional.empty();
        }
    }

    private boolean isCreateOperation() {
        return RequestContextHolder.getRequestAttributes() instanceof ServletRequestAttributes && ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest().getMethod().equalsIgnoreCase("POST");
    }
}

